// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsecuretunneling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTunnelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at once.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the IoT thing associated with the destination device.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s ListTunnelsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTunnelsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTunnelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTunnelsOutput struct {
	_ struct{} `type:"structure"`

	// A token to used to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A short description of the tunnels in an AWS account.
	TunnelSummaries []TunnelSummary `locationName:"tunnelSummaries" type:"list"`
}

// String returns the string representation
func (s ListTunnelsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTunnels = "ListTunnels"

// ListTunnelsRequest returns a request value for making API operation for
// AWS IoT Secure Tunneling.
//
// List all tunnels for an AWS account. Tunnels are listed by creation time
// in descending order, newer tunnels will be listed before older tunnels.
//
//    // Example sending a request using ListTunnelsRequest.
//    req := client.ListTunnelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTunnels
func (c *Client) ListTunnelsRequest(input *ListTunnelsInput) ListTunnelsRequest {
	op := &aws.Operation{
		Name:       opListTunnels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTunnelsInput{}
	}

	req := c.newRequest(op, input, &ListTunnelsOutput{})

	return ListTunnelsRequest{Request: req, Input: input, Copy: c.ListTunnelsRequest}
}

// ListTunnelsRequest is the request type for the
// ListTunnels API operation.
type ListTunnelsRequest struct {
	*aws.Request
	Input *ListTunnelsInput
	Copy  func(*ListTunnelsInput) ListTunnelsRequest
}

// Send marshals and sends the ListTunnels API request.
func (r ListTunnelsRequest) Send(ctx context.Context) (*ListTunnelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTunnelsResponse{
		ListTunnelsOutput: r.Request.Data.(*ListTunnelsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTunnelsRequestPaginator returns a paginator for ListTunnels.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTunnelsRequest(input)
//   p := iotsecuretunneling.NewListTunnelsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTunnelsPaginator(req ListTunnelsRequest) ListTunnelsPaginator {
	return ListTunnelsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTunnelsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTunnelsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTunnelsPaginator struct {
	aws.Pager
}

func (p *ListTunnelsPaginator) CurrentPage() *ListTunnelsOutput {
	return p.Pager.CurrentPage().(*ListTunnelsOutput)
}

// ListTunnelsResponse is the response type for the
// ListTunnels API operation.
type ListTunnelsResponse struct {
	*ListTunnelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTunnels request.
func (r *ListTunnelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
