// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type BatchDisassociateProjectAssetsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the assets to be disassociated from the project.
	//
	// AssetIds is a required field
	AssetIds []string `locationName:"assetIds" min:"1" type:"list" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the project from which to disassociate the assets.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchDisassociateProjectAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisassociateProjectAssetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchDisassociateProjectAssetsInput"}

	if s.AssetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetIds"))
	}
	if s.AssetIds != nil && len(s.AssetIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetIds", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 36))
	}

	if s.ProjectId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDisassociateProjectAssetsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AssetIds != nil {
		v := s.AssetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "assetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProjectId != nil {
		v := *s.ProjectId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "projectId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type BatchDisassociateProjectAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of associated error information, if any.
	Errors []AssetErrorDetails `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchDisassociateProjectAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDisassociateProjectAssetsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opBatchDisassociateProjectAssets = "BatchDisassociateProjectAssets"

// BatchDisassociateProjectAssetsRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Disassociates a group (batch) of assets from an AWS IoT SiteWise Monitor
// project.
//
//    // Example sending a request using BatchDisassociateProjectAssetsRequest.
//    req := client.BatchDisassociateProjectAssetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets
func (c *Client) BatchDisassociateProjectAssetsRequest(input *BatchDisassociateProjectAssetsInput) BatchDisassociateProjectAssetsRequest {
	op := &aws.Operation{
		Name:       opBatchDisassociateProjectAssets,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{projectId}/assets/disassociate",
	}

	if input == nil {
		input = &BatchDisassociateProjectAssetsInput{}
	}

	req := c.newRequest(op, input, &BatchDisassociateProjectAssetsOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return BatchDisassociateProjectAssetsRequest{Request: req, Input: input, Copy: c.BatchDisassociateProjectAssetsRequest}
}

// BatchDisassociateProjectAssetsRequest is the request type for the
// BatchDisassociateProjectAssets API operation.
type BatchDisassociateProjectAssetsRequest struct {
	*aws.Request
	Input *BatchDisassociateProjectAssetsInput
	Copy  func(*BatchDisassociateProjectAssetsInput) BatchDisassociateProjectAssetsRequest
}

// Send marshals and sends the BatchDisassociateProjectAssets API request.
func (r BatchDisassociateProjectAssetsRequest) Send(ctx context.Context) (*BatchDisassociateProjectAssetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchDisassociateProjectAssetsResponse{
		BatchDisassociateProjectAssetsOutput: r.Request.Data.(*BatchDisassociateProjectAssetsOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchDisassociateProjectAssetsResponse is the response type for the
// BatchDisassociateProjectAssets API operation.
type BatchDisassociateProjectAssetsResponse struct {
	*BatchDisassociateProjectAssetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchDisassociateProjectAssets request.
func (r *BatchDisassociateProjectAssetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
