// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The identity for this access policy. Choose either a user or a group but
	// not both.
	//
	// AccessPolicyIdentity is a required field
	AccessPolicyIdentity *Identity `locationName:"accessPolicyIdentity" type:"structure" required:"true"`

	// The permission level for this access policy. Note that a project ADMINISTRATOR
	// is also known as a project owner.
	//
	// AccessPolicyPermission is a required field
	AccessPolicyPermission Permission `locationName:"accessPolicyPermission" type:"string" required:"true" enum:"true"`

	// The AWS IoT SiteWise Monitor resource for this access policy. Choose either
	// portal or project but not both.
	//
	// AccessPolicyResource is a required field
	AccessPolicyResource *Resource `locationName:"accessPolicyResource" type:"structure" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// A list of key-value pairs that contain metadata for the access policy. For
	// more information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAccessPolicyInput"}

	if s.AccessPolicyIdentity == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessPolicyIdentity"))
	}
	if len(s.AccessPolicyPermission) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AccessPolicyPermission"))
	}

	if s.AccessPolicyResource == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessPolicyResource"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.AccessPolicyIdentity != nil {
		if err := s.AccessPolicyIdentity.Validate(); err != nil {
			invalidParams.AddNested("AccessPolicyIdentity", err.(aws.ErrInvalidParams))
		}
	}
	if s.AccessPolicyResource != nil {
		if err := s.AccessPolicyResource.Validate(); err != nil {
			invalidParams.AddNested("AccessPolicyResource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAccessPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccessPolicyIdentity != nil {
		v := s.AccessPolicyIdentity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessPolicyIdentity", v, metadata)
	}
	if len(s.AccessPolicyPermission) > 0 {
		v := s.AccessPolicyPermission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessPolicyPermission", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AccessPolicyResource != nil {
		v := s.AccessPolicyResource

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessPolicyResource", v, metadata)
	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateAccessPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the access policy, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}
	//
	// AccessPolicyArn is a required field
	AccessPolicyArn *string `locationName:"accessPolicyArn" min:"1" type:"string" required:"true"`

	// The ID of the access policy.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `locationName:"accessPolicyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAccessPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessPolicyArn != nil {
		v := *s.AccessPolicyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessPolicyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccessPolicyId != nil {
		v := *s.AccessPolicyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessPolicyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateAccessPolicy = "CreateAccessPolicy"

// CreateAccessPolicyRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Creates an access policy that grants the specified AWS Single Sign-On user
// or group access to the specified AWS IoT SiteWise Monitor portal or project
// resource.
//
//    // Example sending a request using CreateAccessPolicyRequest.
//    req := client.CreateAccessPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy
func (c *Client) CreateAccessPolicyRequest(input *CreateAccessPolicyInput) CreateAccessPolicyRequest {
	op := &aws.Operation{
		Name:       opCreateAccessPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/access-policies",
	}

	if input == nil {
		input = &CreateAccessPolicyInput{}
	}

	req := c.newRequest(op, input, &CreateAccessPolicyOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return CreateAccessPolicyRequest{Request: req, Input: input, Copy: c.CreateAccessPolicyRequest}
}

// CreateAccessPolicyRequest is the request type for the
// CreateAccessPolicy API operation.
type CreateAccessPolicyRequest struct {
	*aws.Request
	Input *CreateAccessPolicyInput
	Copy  func(*CreateAccessPolicyInput) CreateAccessPolicyRequest
}

// Send marshals and sends the CreateAccessPolicy API request.
func (r CreateAccessPolicyRequest) Send(ctx context.Context) (*CreateAccessPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAccessPolicyResponse{
		CreateAccessPolicyOutput: r.Request.Data.(*CreateAccessPolicyOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAccessPolicyResponse is the response type for the
// CreateAccessPolicy API operation.
type CreateAccessPolicyResponse struct {
	*CreateAccessPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAccessPolicy request.
func (r *CreateAccessPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
