// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateDashboardInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The dashboard definition specified in a JSON literal. For detailed information,
	// see Creating Dashboards (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// DashboardDefinition is a required field
	DashboardDefinition *string `locationName:"dashboardDefinition" type:"string" required:"true"`

	// A description for the dashboard.
	DashboardDescription *string `locationName:"dashboardDescription" min:"1" type:"string"`

	// A friendly name for the dashboard.
	//
	// DashboardName is a required field
	DashboardName *string `locationName:"dashboardName" min:"1" type:"string" required:"true"`

	// The ID of the project in which to create the dashboard.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"36" type:"string" required:"true"`

	// A list of key-value pairs that contain metadata for the dashboard. For more
	// information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDashboardInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDashboardInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 36))
	}

	if s.DashboardDefinition == nil {
		invalidParams.Add(aws.NewErrParamRequired("DashboardDefinition"))
	}
	if s.DashboardDescription != nil && len(*s.DashboardDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DashboardDescription", 1))
	}

	if s.DashboardName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DashboardName"))
	}
	if s.DashboardName != nil && len(*s.DashboardName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DashboardName", 1))
	}

	if s.ProjectId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectId", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDashboardInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardDefinition != nil {
		v := *s.DashboardDefinition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardDefinition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardDescription != nil {
		v := *s.DashboardDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardName != nil {
		v := *s.DashboardName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProjectId != nil {
		v := *s.ProjectId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "projectId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the dashboard, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}
	//
	// DashboardArn is a required field
	DashboardArn *string `locationName:"dashboardArn" min:"1" type:"string" required:"true"`

	// The ID of the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `locationName:"dashboardId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDashboardOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DashboardArn != nil {
		v := *s.DashboardArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateDashboard = "CreateDashboard"

// CreateDashboardRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Creates a dashboard in an AWS IoT SiteWise Monitor project.
//
//    // Example sending a request using CreateDashboardRequest.
//    req := client.CreateDashboardRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard
func (c *Client) CreateDashboardRequest(input *CreateDashboardInput) CreateDashboardRequest {
	op := &aws.Operation{
		Name:       opCreateDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/dashboards",
	}

	if input == nil {
		input = &CreateDashboardInput{}
	}

	req := c.newRequest(op, input, &CreateDashboardOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return CreateDashboardRequest{Request: req, Input: input, Copy: c.CreateDashboardRequest}
}

// CreateDashboardRequest is the request type for the
// CreateDashboard API operation.
type CreateDashboardRequest struct {
	*aws.Request
	Input *CreateDashboardInput
	Copy  func(*CreateDashboardInput) CreateDashboardRequest
}

// Send marshals and sends the CreateDashboard API request.
func (r CreateDashboardRequest) Send(ctx context.Context) (*CreateDashboardResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDashboardResponse{
		CreateDashboardOutput: r.Request.Data.(*CreateDashboardOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDashboardResponse is the response type for the
// CreateDashboard API operation.
type CreateDashboardResponse struct {
	*CreateDashboardOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDashboard request.
func (r *CreateDashboardResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
