// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteAssetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset to delete.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteAssetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAssetInput"}

	if s.AssetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAssetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "assetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteAssetOutput struct {
	_ struct{} `type:"structure"`

	// The status of the asset, which contains a state (DELETING after successfully
	// calling this operation) and any error message.
	//
	// AssetStatus is a required field
	AssetStatus *AssetStatus `locationName:"assetStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAssetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetStatus != nil {
		v := s.AssetStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "assetStatus", v, metadata)
	}
	return nil
}

const opDeleteAsset = "DeleteAsset"

// DeleteAssetRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Deletes an asset. This action can't be undone. For more information, see
// Deleting Assets and Models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html)
// in the AWS IoT SiteWise User Guide.
//
// You can't delete an asset that's associated to another asset. For more information,
// see DisassociateAssets (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html).
//
//    // Example sending a request using DeleteAssetRequest.
//    req := client.DeleteAssetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset
func (c *Client) DeleteAssetRequest(input *DeleteAssetInput) DeleteAssetRequest {
	op := &aws.Operation{
		Name:       opDeleteAsset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/assets/{assetId}",
	}

	if input == nil {
		input = &DeleteAssetInput{}
	}

	req := c.newRequest(op, input, &DeleteAssetOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return DeleteAssetRequest{Request: req, Input: input, Copy: c.DeleteAssetRequest}
}

// DeleteAssetRequest is the request type for the
// DeleteAsset API operation.
type DeleteAssetRequest struct {
	*aws.Request
	Input *DeleteAssetInput
	Copy  func(*DeleteAssetInput) DeleteAssetRequest
}

// Send marshals and sends the DeleteAsset API request.
func (r DeleteAssetRequest) Send(ctx context.Context) (*DeleteAssetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAssetResponse{
		DeleteAssetOutput: r.Request.Data.(*DeleteAssetOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAssetResponse is the response type for the
// DeleteAsset API operation.
type DeleteAssetResponse struct {
	*DeleteAssetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAsset request.
func (r *DeleteAssetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
