// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the access policy.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `location:"uri" locationName:"accessPolicyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccessPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAccessPolicyInput"}

	if s.AccessPolicyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessPolicyId"))
	}
	if s.AccessPolicyId != nil && len(*s.AccessPolicyId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("AccessPolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAccessPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccessPolicyId != nil {
		v := *s.AccessPolicyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accessPolicyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeAccessPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the access policy, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}
	//
	// AccessPolicyArn is a required field
	AccessPolicyArn *string `locationName:"accessPolicyArn" min:"1" type:"string" required:"true"`

	// The date the access policy was created, in Unix epoch time.
	//
	// AccessPolicyCreationDate is a required field
	AccessPolicyCreationDate *time.Time `locationName:"accessPolicyCreationDate" type:"timestamp" required:"true"`

	// The ID of the access policy.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `locationName:"accessPolicyId" min:"36" type:"string" required:"true"`

	// The AWS SSO identity (user or group) to which this access policy applies.
	//
	// AccessPolicyIdentity is a required field
	AccessPolicyIdentity *Identity `locationName:"accessPolicyIdentity" type:"structure" required:"true"`

	// The date the access policy was last updated, in Unix epoch time.
	//
	// AccessPolicyLastUpdateDate is a required field
	AccessPolicyLastUpdateDate *time.Time `locationName:"accessPolicyLastUpdateDate" type:"timestamp" required:"true"`

	// The access policy permission. Note that a project ADMINISTRATOR is also known
	// as a project owner.
	//
	// AccessPolicyPermission is a required field
	AccessPolicyPermission Permission `locationName:"accessPolicyPermission" type:"string" required:"true" enum:"true"`

	// The AWS IoT SiteWise Monitor resource (portal or project) to which this access
	// policy provides access.
	//
	// AccessPolicyResource is a required field
	AccessPolicyResource *Resource `locationName:"accessPolicyResource" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAccessPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessPolicyArn != nil {
		v := *s.AccessPolicyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessPolicyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccessPolicyCreationDate != nil {
		v := *s.AccessPolicyCreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessPolicyCreationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.AccessPolicyId != nil {
		v := *s.AccessPolicyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessPolicyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccessPolicyIdentity != nil {
		v := s.AccessPolicyIdentity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessPolicyIdentity", v, metadata)
	}
	if s.AccessPolicyLastUpdateDate != nil {
		v := *s.AccessPolicyLastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessPolicyLastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.AccessPolicyPermission) > 0 {
		v := s.AccessPolicyPermission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessPolicyPermission", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AccessPolicyResource != nil {
		v := s.AccessPolicyResource

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessPolicyResource", v, metadata)
	}
	return nil
}

const opDescribeAccessPolicy = "DescribeAccessPolicy"

// DescribeAccessPolicyRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Describes an access policy, which specifies an AWS SSO user or group's access
// to an AWS IoT SiteWise Monitor portal or project.
//
//    // Example sending a request using DescribeAccessPolicyRequest.
//    req := client.DescribeAccessPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy
func (c *Client) DescribeAccessPolicyRequest(input *DescribeAccessPolicyInput) DescribeAccessPolicyRequest {
	op := &aws.Operation{
		Name:       opDescribeAccessPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/access-policies/{accessPolicyId}",
	}

	if input == nil {
		input = &DescribeAccessPolicyInput{}
	}

	req := c.newRequest(op, input, &DescribeAccessPolicyOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return DescribeAccessPolicyRequest{Request: req, Input: input, Copy: c.DescribeAccessPolicyRequest}
}

// DescribeAccessPolicyRequest is the request type for the
// DescribeAccessPolicy API operation.
type DescribeAccessPolicyRequest struct {
	*aws.Request
	Input *DescribeAccessPolicyInput
	Copy  func(*DescribeAccessPolicyInput) DescribeAccessPolicyRequest
}

// Send marshals and sends the DescribeAccessPolicy API request.
func (r DescribeAccessPolicyRequest) Send(ctx context.Context) (*DescribeAccessPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAccessPolicyResponse{
		DescribeAccessPolicyOutput: r.Request.Data.(*DescribeAccessPolicyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAccessPolicyResponse is the response type for the
// DescribeAccessPolicy API operation.
type DescribeAccessPolicyResponse struct {
	*DescribeAccessPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAccessPolicy request.
func (r *DescribeAccessPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
