// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeProjectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProjectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeProjectInput"}

	if s.ProjectId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeProjectInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ProjectId != nil {
		v := *s.ProjectId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "projectId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeProjectOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the portal that the project is in.
	//
	// PortalId is a required field
	PortalId *string `locationName:"portalId" min:"36" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the project, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"1" type:"string" required:"true"`

	// The date the project was created, in Unix epoch time.
	//
	// ProjectCreationDate is a required field
	ProjectCreationDate *time.Time `locationName:"projectCreationDate" type:"timestamp" required:"true"`

	// The project's description.
	ProjectDescription *string `locationName:"projectDescription" min:"1" type:"string"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"36" type:"string" required:"true"`

	// The date the project was last updated, in Unix epoch time.
	//
	// ProjectLastUpdateDate is a required field
	ProjectLastUpdateDate *time.Time `locationName:"projectLastUpdateDate" type:"timestamp" required:"true"`

	// The name of the project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeProjectOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PortalId != nil {
		v := *s.PortalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProjectArn != nil {
		v := *s.ProjectArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "projectArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProjectCreationDate != nil {
		v := *s.ProjectCreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "projectCreationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ProjectDescription != nil {
		v := *s.ProjectDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "projectDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProjectId != nil {
		v := *s.ProjectId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "projectId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProjectLastUpdateDate != nil {
		v := *s.ProjectLastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "projectLastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ProjectName != nil {
		v := *s.ProjectName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "projectName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Retrieves information about a project.
//
//    // Example sending a request using DescribeProjectRequest.
//    req := client.DescribeProjectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject
func (c *Client) DescribeProjectRequest(input *DescribeProjectInput) DescribeProjectRequest {
	op := &aws.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectId}",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	req := c.newRequest(op, input, &DescribeProjectOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return DescribeProjectRequest{Request: req, Input: input, Copy: c.DescribeProjectRequest}
}

// DescribeProjectRequest is the request type for the
// DescribeProject API operation.
type DescribeProjectRequest struct {
	*aws.Request
	Input *DescribeProjectInput
	Copy  func(*DescribeProjectInput) DescribeProjectRequest
}

// Send marshals and sends the DescribeProject API request.
func (r DescribeProjectRequest) Send(ctx context.Context) (*DescribeProjectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeProjectResponse{
		DescribeProjectOutput: r.Request.Data.(*DescribeProjectOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeProjectResponse is the response type for the
// DescribeProject API operation.
type DescribeProjectResponse struct {
	*DescribeProjectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeProject request.
func (r *DescribeProjectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
