// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListGatewaysInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewaysInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListGatewaysInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListGatewaysInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each gateway.
	//
	// GatewaySummaries is a required field
	GatewaySummaries []GatewaySummary `locationName:"gatewaySummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListGatewaysOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GatewaySummaries != nil {
		v := s.GatewaySummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "gatewaySummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListGateways = "ListGateways"

// ListGatewaysRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Retrieves a paginated list of gateways.
//
//    // Example sending a request using ListGatewaysRequest.
//    req := client.ListGatewaysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways
func (c *Client) ListGatewaysRequest(input *ListGatewaysInput) ListGatewaysRequest {
	op := &aws.Operation{
		Name:       opListGateways,
		HTTPMethod: "GET",
		HTTPPath:   "/20200301/gateways",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewaysInput{}
	}

	req := c.newRequest(op, input, &ListGatewaysOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("edge.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return ListGatewaysRequest{Request: req, Input: input, Copy: c.ListGatewaysRequest}
}

// ListGatewaysRequest is the request type for the
// ListGateways API operation.
type ListGatewaysRequest struct {
	*aws.Request
	Input *ListGatewaysInput
	Copy  func(*ListGatewaysInput) ListGatewaysRequest
}

// Send marshals and sends the ListGateways API request.
func (r ListGatewaysRequest) Send(ctx context.Context) (*ListGatewaysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListGatewaysResponse{
		ListGatewaysOutput: r.Request.Data.(*ListGatewaysOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListGatewaysRequestPaginator returns a paginator for ListGateways.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListGatewaysRequest(input)
//   p := iotsitewise.NewListGatewaysRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListGatewaysPaginator(req ListGatewaysRequest) ListGatewaysPaginator {
	return ListGatewaysPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListGatewaysInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListGatewaysPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListGatewaysPaginator struct {
	aws.Pager
}

func (p *ListGatewaysPaginator) CurrentPage() *ListGatewaysOutput {
	return p.Pager.CurrentPage().(*ListGatewaysOutput)
}

// ListGatewaysResponse is the response type for the
// ListGateways API operation.
type ListGatewaysResponse struct {
	*ListGatewaysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListGateways request.
func (r *ListGatewaysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
