// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListProjectAssetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s ListProjectAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectAssetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListProjectAssetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.ProjectId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProjectAssetsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ProjectId != nil {
		v := *s.ProjectId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "projectId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListProjectAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the IDs of each asset associated with the project.
	//
	// AssetIds is a required field
	AssetIds []string `locationName:"assetIds" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListProjectAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProjectAssetsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetIds != nil {
		v := s.AssetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "assetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListProjectAssets = "ListProjectAssets"

// ListProjectAssetsRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Retrieves a paginated list of assets associated with an AWS IoT SiteWise
// Monitor project.
//
//    // Example sending a request using ListProjectAssetsRequest.
//    req := client.ListProjectAssetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets
func (c *Client) ListProjectAssetsRequest(input *ListProjectAssetsInput) ListProjectAssetsRequest {
	op := &aws.Operation{
		Name:       opListProjectAssets,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectId}/assets",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectAssetsInput{}
	}

	req := c.newRequest(op, input, &ListProjectAssetsOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return ListProjectAssetsRequest{Request: req, Input: input, Copy: c.ListProjectAssetsRequest}
}

// ListProjectAssetsRequest is the request type for the
// ListProjectAssets API operation.
type ListProjectAssetsRequest struct {
	*aws.Request
	Input *ListProjectAssetsInput
	Copy  func(*ListProjectAssetsInput) ListProjectAssetsRequest
}

// Send marshals and sends the ListProjectAssets API request.
func (r ListProjectAssetsRequest) Send(ctx context.Context) (*ListProjectAssetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListProjectAssetsResponse{
		ListProjectAssetsOutput: r.Request.Data.(*ListProjectAssetsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListProjectAssetsRequestPaginator returns a paginator for ListProjectAssets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListProjectAssetsRequest(input)
//   p := iotsitewise.NewListProjectAssetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListProjectAssetsPaginator(req ListProjectAssetsRequest) ListProjectAssetsPaginator {
	return ListProjectAssetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListProjectAssetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListProjectAssetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListProjectAssetsPaginator struct {
	aws.Pager
}

func (p *ListProjectAssetsPaginator) CurrentPage() *ListProjectAssetsOutput {
	return p.Pager.CurrentPage().(*ListProjectAssetsOutput)
}

// ListProjectAssetsResponse is the response type for the
// ListProjectAssets API operation.
type ListProjectAssetsResponse struct {
	*ListProjectAssetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListProjectAssets request.
func (r *ListProjectAssetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
