// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains an access policy that defines an AWS SSO identity's access to an
// AWS IoT SiteWise Monitor resource.
type AccessPolicySummary struct {
	_ struct{} `type:"structure"`

	// The date the access policy was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The ID of the access policy.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The AWS SSO identity (a user or group).
	//
	// Identity is a required field
	Identity *Identity `locationName:"identity" type:"structure" required:"true"`

	// The date the access policy was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The permissions for the access policy. Note that a project ADMINISTRATOR
	// is also known as a project owner.
	//
	// Permission is a required field
	Permission Permission `locationName:"permission" type:"string" required:"true" enum:"true"`

	// The AWS IoT SiteWise Monitor resource (a portal or project).
	//
	// Resource is a required field
	Resource *Resource `locationName:"resource" type:"structure" required:"true"`
}

// String returns the string representation
func (s AccessPolicySummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessPolicySummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Identity != nil {
		v := s.Identity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "identity", v, metadata)
	}
	if s.LastUpdateDate != nil {
		v := *s.LastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.Permission) > 0 {
		v := s.Permission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "permission", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Resource != nil {
		v := s.Resource

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resource", v, metadata)
	}
	return nil
}

// Contains aggregated asset property values (for example, average, minimum,
// and maximum).
type AggregatedValue struct {
	_ struct{} `type:"structure"`

	// The quality of the aggregated data.
	Quality Quality `locationName:"quality" type:"string" enum:"true"`

	// The date the aggregating computations occurred, in Unix epoch time.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" required:"true"`

	// The value of the aggregates.
	//
	// Value is a required field
	Value *Aggregates `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation
func (s AggregatedValue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AggregatedValue) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Quality) > 0 {
		v := s.Quality

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "quality", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Value != nil {
		v := s.Value

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "value", v, metadata)
	}
	return nil
}

// Contains the (pre-calculated) aggregate values for an asset property.
type Aggregates struct {
	_ struct{} `type:"structure"`

	// The average (mean) value of the time series over a time interval window.
	Average *float64 `locationName:"average" type:"double"`

	// The count of data points in the time series over a time interval window.
	Count *float64 `locationName:"count" type:"double"`

	// The maximum value of the time series over a time interval window.
	Maximum *float64 `locationName:"maximum" type:"double"`

	// The minimum value of the time series over a time interval window.
	Minimum *float64 `locationName:"minimum" type:"double"`

	// The standard deviation of the time series over a time interval window.
	StandardDeviation *float64 `locationName:"standardDeviation" type:"double"`

	// The sum of the time series over a time interval window.
	Sum *float64 `locationName:"sum" type:"double"`
}

// String returns the string representation
func (s Aggregates) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Aggregates) MarshalFields(e protocol.FieldEncoder) error {
	if s.Average != nil {
		v := *s.Average

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "average", protocol.Float64Value(v), metadata)
	}
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Float64Value(v), metadata)
	}
	if s.Maximum != nil {
		v := *s.Maximum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maximum", protocol.Float64Value(v), metadata)
	}
	if s.Minimum != nil {
		v := *s.Minimum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minimum", protocol.Float64Value(v), metadata)
	}
	if s.StandardDeviation != nil {
		v := *s.StandardDeviation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "standardDeviation", protocol.Float64Value(v), metadata)
	}
	if s.Sum != nil {
		v := *s.Sum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sum", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Contains error details for the requested associate project asset action.
type AssetErrorDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" min:"36" type:"string" required:"true"`

	// The error code.
	//
	// Code is a required field
	Code AssetErrorCode `locationName:"code" type:"string" required:"true" enum:"true"`

	// The error message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation
func (s AssetErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetErrorDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Code) > 0 {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "code", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an asset hierarchy that contains a hierarchy's name and ID.
type AssetHierarchy struct {
	_ struct{} `type:"structure"`

	// The ID of the hierarchy. This ID is a hierarchyId.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The hierarchy name provided in the CreateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)
	// API.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssetHierarchy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetHierarchy) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an asset hierarchy that contains a hierarchy's name, ID, and child
// asset model ID that specifies the type of asset that can be in this hierarchy.
type AssetModelHierarchy struct {
	_ struct{} `type:"structure"`

	// The ID of the asset model. All assets in this hierarchy must be instances
	// of the childAssetModelId asset model.
	//
	// ChildAssetModelId is a required field
	ChildAssetModelId *string `locationName:"childAssetModelId" min:"36" type:"string" required:"true"`

	// The ID of the asset model hierarchy. This ID is a hierarchyId.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The name of the asset model hierarchy that you specify by using the CreateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)
	// API.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssetModelHierarchy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelHierarchy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssetModelHierarchy"}

	if s.ChildAssetModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChildAssetModelId"))
	}
	if s.ChildAssetModelId != nil && len(*s.ChildAssetModelId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ChildAssetModelId", 36))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 36))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetModelHierarchy) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChildAssetModelId != nil {
		v := *s.ChildAssetModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "childAssetModelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains an asset model hierarchy used in asset model creation. An asset
// model hierarchy determines the kind (or type) of asset that can belong to
// a hierarchy.
type AssetModelHierarchyDefinition struct {
	_ struct{} `type:"structure"`

	// The ID of an asset model for this hierarchy.
	//
	// ChildAssetModelId is a required field
	ChildAssetModelId *string `locationName:"childAssetModelId" min:"36" type:"string" required:"true"`

	// The name of the asset model hierarchy definition (as specified in CreateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)).
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssetModelHierarchyDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelHierarchyDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssetModelHierarchyDefinition"}

	if s.ChildAssetModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChildAssetModelId"))
	}
	if s.ChildAssetModelId != nil && len(*s.ChildAssetModelId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ChildAssetModelId", 36))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetModelHierarchyDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChildAssetModelId != nil {
		v := *s.ChildAssetModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "childAssetModelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about an asset model property.
type AssetModelProperty struct {
	_ struct{} `type:"structure"`

	// The data type of the asset model property.
	//
	// DataType is a required field
	DataType PropertyDataType `locationName:"dataType" type:"string" required:"true" enum:"true"`

	// The ID of the asset model property.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The name of the asset model property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The property type (see PropertyType).
	//
	// Type is a required field
	Type *PropertyType `locationName:"type" type:"structure" required:"true"`

	// The unit of the asset model property, such as Newtons or RPM.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation
func (s AssetModelProperty) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelProperty) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssetModelProperty"}
	if len(s.DataType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("DataType"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 36))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Unit != nil && len(*s.Unit) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Unit", 1))
	}
	if s.Type != nil {
		if err := s.Type.Validate(); err != nil {
			invalidParams.AddNested("Type", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetModelProperty) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DataType) > 0 {
		v := s.DataType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "type", v, metadata)
	}
	if s.Unit != nil {
		v := *s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unit", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains an asset model property definition. This property definition is
// applied to all assets created from the asset model.
type AssetModelPropertyDefinition struct {
	_ struct{} `type:"structure"`

	// The data type of the property definition.
	//
	// DataType is a required field
	DataType PropertyDataType `locationName:"dataType" type:"string" required:"true" enum:"true"`

	// The name of the property definition.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The property definition type (see PropertyType). You can only specify one
	// type in a property definition.
	//
	// Type is a required field
	Type *PropertyType `locationName:"type" type:"structure" required:"true"`

	// The unit of the property definition, such as Newtons or RPM.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation
func (s AssetModelPropertyDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelPropertyDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssetModelPropertyDefinition"}
	if len(s.DataType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("DataType"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Unit != nil && len(*s.Unit) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Unit", 1))
	}
	if s.Type != nil {
		if err := s.Type.Validate(); err != nil {
			invalidParams.AddNested("Type", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetModelPropertyDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DataType) > 0 {
		v := s.DataType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "type", v, metadata)
	}
	if s.Unit != nil {
		v := *s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unit", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains current status information for an asset model. For more information,
// see Asset and Model States (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html)
// in the AWS IoT SiteWise User Guide.
type AssetModelStatus struct {
	_ struct{} `type:"structure"`

	// Contains associated error information, if any.
	Error *ErrorDetails `locationName:"error" type:"structure"`

	// The current state of the asset model.
	//
	// State is a required field
	State AssetModelState `locationName:"state" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AssetModelStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetModelStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Error != nil {
		v := s.Error

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "error", v, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains a summary of an asset model.
type AssetModelSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset model, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The date the asset model was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The asset model description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The ID of the asset model (used with AWS IoT SiteWise APIs).
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the asset model was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`

	// The name of the asset model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current status of the asset model.
	//
	// Status is a required field
	Status *AssetModelStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation
func (s AssetModelSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetModelSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateDate != nil {
		v := *s.LastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	return nil
}

// Contains asset property information.
type AssetProperty struct {
	_ struct{} `type:"structure"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The data type of the asset property.
	//
	// DataType is a required field
	DataType PropertyDataType `locationName:"dataType" type:"string" required:"true" enum:"true"`

	// The ID of the asset property.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The name of the property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The asset property's notification topic and state. For more information,
	// see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html)
	Notification *PropertyNotification `locationName:"notification" type:"structure"`

	// The unit (such as Newtons or RPM) of the asset property.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation
func (s AssetProperty) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetProperty) MarshalFields(e protocol.FieldEncoder) error {
	if s.Alias != nil {
		v := *s.Alias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "alias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DataType) > 0 {
		v := s.DataType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Notification != nil {
		v := s.Notification

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "notification", v, metadata)
	}
	if s.Unit != nil {
		v := *s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unit", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains asset property value information.
type AssetPropertyValue struct {
	_ struct{} `type:"structure"`

	// The quality of the asset property value.
	Quality Quality `locationName:"quality" type:"string" enum:"true"`

	// The timestamp of the asset property value.
	//
	// Timestamp is a required field
	Timestamp *TimeInNanos `locationName:"timestamp" type:"structure" required:"true"`

	// The value of the asset property (see Variant).
	//
	// Value is a required field
	Value *Variant `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation
func (s AssetPropertyValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetPropertyValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssetPropertyValue"}

	if s.Timestamp == nil {
		invalidParams.Add(aws.NewErrParamRequired("Timestamp"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Timestamp != nil {
		if err := s.Timestamp.Validate(); err != nil {
			invalidParams.AddNested("Timestamp", err.(aws.ErrInvalidParams))
		}
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetPropertyValue) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Quality) > 0 {
		v := s.Quality

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "quality", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Timestamp != nil {
		v := s.Timestamp

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "timestamp", v, metadata)
	}
	if s.Value != nil {
		v := s.Value

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "value", v, metadata)
	}
	return nil
}

// Contains information about the current status of an asset. For more information,
// see Asset and Model States (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html)
// in the AWS IoT SiteWise User Guide.
type AssetStatus struct {
	_ struct{} `type:"structure"`

	// Contains associated error information, if any.
	Error *ErrorDetails `locationName:"error" type:"structure"`

	// The current status of the asset.
	//
	// State is a required field
	State AssetState `locationName:"state" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AssetStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Error != nil {
		v := s.Error

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "error", v, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains a summary of an asset.
type AssetSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The ID of the asset model used to create this asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The date the asset was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// A list of asset hierarchies that each contain a hierarchyId. A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// Hierarchies is a required field
	Hierarchies []AssetHierarchy `locationName:"hierarchies" type:"list" required:"true"`

	// The ID of the asset.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the asset was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`

	// The name of the asset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current status of the asset.
	//
	// Status is a required field
	Status *AssetStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation
func (s AssetSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetModelId != nil {
		v := *s.AssetModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetModelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Hierarchies != nil {
		v := s.Hierarchies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "hierarchies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateDate != nil {
		v := *s.LastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	return nil
}

// Contains a summary of an associated asset.
type AssociatedAssetsSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The ID of the asset model used to create the asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The date the asset was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// A list of asset hierarchies that each contain a hierarchyId. A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// Hierarchies is a required field
	Hierarchies []AssetHierarchy `locationName:"hierarchies" type:"list" required:"true"`

	// The ID of the asset.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the asset was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`

	// The name of the asset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current status of the asset.
	//
	// Status is a required field
	Status *AssetStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation
func (s AssociatedAssetsSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociatedAssetsSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetModelId != nil {
		v := *s.AssetModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetModelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Hierarchies != nil {
		v := s.Hierarchies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "hierarchies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateDate != nil {
		v := *s.LastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	return nil
}

// Contains an asset attribute property. For more information, see Attributes
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#attributes)
// in the AWS IoT SiteWise User Guide.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The default value of the asset model property attribute. All assets that
	// you create from the asset model contain this attribute value. You can update
	// an attribute's value after you create an asset. For more information, see
	// Updating Attribute Values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html)
	// in the AWS IoT SiteWise User Guide.
	DefaultValue *string `locationName:"defaultValue" min:"1" type:"string"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Attribute"}
	if s.DefaultValue != nil && len(*s.DefaultValue) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DefaultValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Attribute) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultValue != nil {
		v := *s.DefaultValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "defaultValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains error information from updating a batch of asset property values.
type BatchPutAssetPropertyError struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// ErrorCode is a required field
	ErrorCode BatchPutAssetPropertyValueErrorCode `locationName:"errorCode" type:"string" required:"true" enum:"true"`

	// The associated error message.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" type:"string" required:"true"`

	// A list of timestamps for each error, if any.
	//
	// Timestamps is a required field
	Timestamps []TimeInNanos `locationName:"timestamps" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutAssetPropertyError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchPutAssetPropertyError) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ErrorCode) > 0 {
		v := s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timestamps != nil {
		v := s.Timestamps

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "timestamps", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Contains error information for asset property value entries that are associated
// with the BatchPutAssetPropertyValue (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html)
// API.
type BatchPutAssetPropertyErrorEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the failed entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The list of update property value errors.
	//
	// Errors is a required field
	Errors []BatchPutAssetPropertyError `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutAssetPropertyErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchPutAssetPropertyErrorEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.EntryId != nil {
		v := *s.EntryId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entryId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Contains a dashboard summary.
type DashboardSummary struct {
	_ struct{} `type:"structure"`

	// The date the dashboard was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The dashboard's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the dashboard.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the dashboard was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The name of the dashboard
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DashboardSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashboardSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateDate != nil {
		v := *s.LastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the details of an AWS IoT SiteWise error.
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// Code is a required field
	Code ErrorCode `locationName:"code" type:"string" required:"true" enum:"true"`

	// The error message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorDetails) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Code) > 0 {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "code", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains expression variable information.
type ExpressionVariable struct {
	_ struct{} `type:"structure"`

	// The friendly name of the variable to be used in the expression.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The variable that identifies an asset property from which to use values.
	//
	// Value is a required field
	Value *VariableValue `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExpressionVariable) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExpressionVariable) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExpressionVariable"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExpressionVariable) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := s.Value

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "value", v, metadata)
	}
	return nil
}

// Contains a summary of a gateway capability configuration.
type GatewayCapabilitySummary struct {
	_ struct{} `type:"structure"`

	// The namespace of the capability configuration. For example, if you configure
	// OPC-UA sources from the AWS IoT SiteWise console, your OPC-UA capability
	// configuration has the namespace iotsitewise:opcuacollector:version, where
	// version is a number such as 1.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The synchronization status of the capability configuration. The sync status
	// can be one of the following:
	//
	//    * IN_SYNC – The gateway is running the capability configuration.
	//
	//    * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
	//
	//    * SYNC_FAILED – The gateway rejected the capability configuration.
	//
	// CapabilitySyncStatus is a required field
	CapabilitySyncStatus CapabilitySyncStatus `locationName:"capabilitySyncStatus" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GatewayCapabilitySummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GatewayCapabilitySummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CapabilityNamespace != nil {
		v := *s.CapabilityNamespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "capabilityNamespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CapabilitySyncStatus) > 0 {
		v := s.CapabilitySyncStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "capabilitySyncStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains a gateway's platform information.
type GatewayPlatform struct {
	_ struct{} `type:"structure"`

	// A gateway that runs on AWS IoT Greengrass.
	//
	// Greengrass is a required field
	Greengrass *Greengrass `locationName:"greengrass" type:"structure" required:"true"`
}

// String returns the string representation
func (s GatewayPlatform) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GatewayPlatform) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GatewayPlatform"}

	if s.Greengrass == nil {
		invalidParams.Add(aws.NewErrParamRequired("Greengrass"))
	}
	if s.Greengrass != nil {
		if err := s.Greengrass.Validate(); err != nil {
			invalidParams.AddNested("Greengrass", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GatewayPlatform) MarshalFields(e protocol.FieldEncoder) error {
	if s.Greengrass != nil {
		v := s.Greengrass

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "greengrass", v, metadata)
	}
	return nil
}

// Contains a summary of a gateway.
type GatewaySummary struct {
	_ struct{} `type:"structure"`

	// The date the gateway was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// A list of gateway capability summaries that each contain a namespace and
	// status. Each gateway capability defines data sources for the gateway. To
	// retrieve a capability configuration's definition, use DescribeGatewayCapabilityConfiguration
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html).
	GatewayCapabilitySummaries []GatewayCapabilitySummary `locationName:"gatewayCapabilitySummaries" type:"list"`

	// The ID of the gateway device.
	//
	// GatewayId is a required field
	GatewayId *string `locationName:"gatewayId" min:"36" type:"string" required:"true"`

	// The name of the asset.
	//
	// GatewayName is a required field
	GatewayName *string `locationName:"gatewayName" min:"1" type:"string" required:"true"`

	// The date the gateway was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GatewaySummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GatewaySummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.GatewayCapabilitySummaries != nil {
		v := s.GatewayCapabilitySummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "gatewayCapabilitySummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.GatewayId != nil {
		v := *s.GatewayId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gatewayId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GatewayName != nil {
		v := *s.GatewayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gatewayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateDate != nil {
		v := *s.LastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Contains details for a gateway that runs on AWS IoT Greengrass. To create
// a gateway that runs on AWS IoT Greengrass, you must add the IoT SiteWise
// connector to a Greengrass group and deploy it. Your Greengrass group must
// also have permissions to upload data to AWS IoT SiteWise. For more information,
// see Ingesting data using a gateway (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html)
// in the AWS IoT SiteWise User Guide.
type Greengrass struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Greengrass group. For more information about how to find a group's
	// ARN, see ListGroups (https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html)
	// and GetGroup (https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html)
	// in the AWS IoT Greengrass API Reference.
	//
	// GroupArn is a required field
	GroupArn *string `locationName:"groupArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Greengrass) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Greengrass) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Greengrass"}

	if s.GroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupArn"))
	}
	if s.GroupArn != nil && len(*s.GroupArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Greengrass) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupArn != nil {
		v := *s.GroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information for a group identity in an access policy.
type GroupIdentity struct {
	_ struct{} `type:"structure"`

	// The AWS SSO ID of the group.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GroupIdentity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupIdentity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GroupIdentity"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupIdentity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains an AWS SSO identity ID for a user or group.
//
// Currently, you can't use AWS APIs to retrieve AWS SSO identity IDs. You can
// find the AWS SSO identity IDs in the URL of user and group pages in the AWS
// SSO console (https://console.aws.amazon.com/singlesignon).
type Identity struct {
	_ struct{} `type:"structure"`

	// A group identity.
	Group *GroupIdentity `locationName:"group" type:"structure"`

	// A user identity.
	User *UserIdentity `locationName:"user" type:"structure"`
}

// String returns the string representation
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Identity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Identity"}
	if s.Group != nil {
		if err := s.Group.Validate(); err != nil {
			invalidParams.AddNested("Group", err.(aws.ErrInvalidParams))
		}
	}
	if s.User != nil {
		if err := s.User.Validate(); err != nil {
			invalidParams.AddNested("User", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Identity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Group != nil {
		v := s.Group

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "group", v, metadata)
	}
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "user", v, metadata)
	}
	return nil
}

// Contains an image that is one of the following:
//
//    * An image file. Choose this option to upload a new image.
//
//    * The ID of an existing image. Choose this option to keep an existing
//    image.
type Image struct {
	_ struct{} `type:"structure"`

	// Contains an image file.
	File *ImageFile `locationName:"file" type:"structure"`

	// The ID of an existing image. Specify this parameter to keep an existing image.
	Id *string `locationName:"id" min:"36" type:"string"`
}

// String returns the string representation
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Image) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Image"}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 36))
	}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Image) MarshalFields(e protocol.FieldEncoder) error {
	if s.File != nil {
		v := s.File

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "file", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains an image file.
type ImageFile struct {
	_ struct{} `type:"structure"`

	// The image file contents, represented as a base64-encoded string. The file
	// size must be less than 1 MB.
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `locationName:"data" min:"1" type:"blob" required:"true"`

	// The file type of the image.
	//
	// Type is a required field
	Type ImageFileType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ImageFile) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImageFile) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ImageFile"}

	if s.Data == nil {
		invalidParams.Add(aws.NewErrParamRequired("Data"))
	}
	if s.Data != nil && len(s.Data) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Data", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImageFile) MarshalFields(e protocol.FieldEncoder) error {
	if s.Data != nil {
		v := s.Data

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "data", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains an image that is uploaded to AWS IoT SiteWise and available at a
// URL.
type ImageLocation struct {
	_ struct{} `type:"structure"`

	// The ID of the image.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The URL where the image is available. The URL is valid for 15 minutes so
	// that you can view and download the image
	//
	// Url is a required field
	Url *string `locationName:"url" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ImageLocation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImageLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains logging options.
type LoggingOptions struct {
	_ struct{} `type:"structure"`

	// The AWS IoT SiteWise logging verbosity level.
	//
	// Level is a required field
	Level LoggingLevel `locationName:"level" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s LoggingOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoggingOptions"}
	if len(s.Level) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Level"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoggingOptions) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Level) > 0 {
		v := s.Level

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "level", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains an asset measurement property. This structure is empty. For more
// information, see Measurements (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#measurements)
// in the AWS IoT SiteWise User Guide.
type Measurement struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Measurement) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Measurement) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Contains an asset metric property. With metrics, you can calculate aggregate
// functions, such as an average, maximum, or minimum, as specified through
// an expression. A metric maps several values to a single value (such as a
// sum).
//
// The maximum number of dependent/cascading variables used in any one metric
// calculation is 10. Therefore, a root metric can have up to 10 cascading metrics
// in its computational dependency tree. Additionally, a metric can only have
// a data type of DOUBLE and consume properties with data types of INTEGER or
// DOUBLE.
//
// For more information, see Metrics (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#metrics)
// in the AWS IoT SiteWise User Guide.
type Metric struct {
	_ struct{} `type:"structure"`

	// The mathematical expression that defines the metric aggregation function.
	// You can specify up to 10 variables per expression. You can specify up to
	// 10 functions per expression.
	//
	// For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The list of variables used in the expression.
	//
	// Variables is a required field
	Variables []ExpressionVariable `locationName:"variables" type:"list" required:"true"`

	// The window (time interval) over which AWS IoT SiteWise computes the metric's
	// aggregation expression. AWS IoT SiteWise computes one data point per window.
	//
	// Window is a required field
	Window *MetricWindow `locationName:"window" type:"structure" required:"true"`
}

// String returns the string representation
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metric) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Metric"}

	if s.Expression == nil {
		invalidParams.Add(aws.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Expression", 1))
	}

	if s.Variables == nil {
		invalidParams.Add(aws.NewErrParamRequired("Variables"))
	}

	if s.Window == nil {
		invalidParams.Add(aws.NewErrParamRequired("Window"))
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Window != nil {
		if err := s.Window.Validate(); err != nil {
			invalidParams.AddNested("Window", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Metric) MarshalFields(e protocol.FieldEncoder) error {
	if s.Expression != nil {
		v := *s.Expression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Variables != nil {
		v := s.Variables

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "variables", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Window != nil {
		v := s.Window

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "window", v, metadata)
	}
	return nil
}

// Contains a time interval window used for data aggregate computations (for
// example, average, sum, count, and so on).
type MetricWindow struct {
	_ struct{} `type:"structure"`

	// The tumbling time interval window.
	Tumbling *TumblingWindow `locationName:"tumbling" type:"structure"`
}

// String returns the string representation
func (s MetricWindow) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricWindow) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricWindow"}
	if s.Tumbling != nil {
		if err := s.Tumbling.Validate(); err != nil {
			invalidParams.AddNested("Tumbling", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricWindow) MarshalFields(e protocol.FieldEncoder) error {
	if s.Tumbling != nil {
		v := s.Tumbling

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "tumbling", v, metadata)
	}
	return nil
}

// Contains AWS IoT SiteWise Monitor error details.
type MonitorErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code MonitorErrorCode `locationName:"code" type:"string" enum:"true"`

	// The error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MonitorErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MonitorErrorDetails) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Code) > 0 {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "code", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Identifies an AWS IoT SiteWise Monitor portal.
type PortalResource struct {
	_ struct{} `type:"structure"`

	// The ID of the portal.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s PortalResource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortalResource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PortalResource"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortalResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the current status of a portal.
type PortalStatus struct {
	_ struct{} `type:"structure"`

	// Contains associated error information, if any.
	Error *MonitorErrorDetails `locationName:"error" type:"structure"`

	// The current state of the portal.
	//
	// State is a required field
	State PortalState `locationName:"state" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s PortalStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortalStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Error != nil {
		v := s.Error

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "error", v, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains a portal summary.
type PortalSummary struct {
	_ struct{} `type:"structure"`

	// The date the portal was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The portal's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the portal.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the portal was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The name of the portal.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the service role that allows the portal's users to access your AWS IoT
	// SiteWise resources on your behalf. For more information, see Using service
	// roles for AWS IoT SiteWise Monitor (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the AWS IoT SiteWise User Guide.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The public root URL for the AWS IoT AWS IoT SiteWise Monitor application
	// portal.
	//
	// StartUrl is a required field
	StartUrl *string `locationName:"startUrl" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PortalSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortalSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateDate != nil {
		v := *s.LastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartUrl != nil {
		v := *s.StartUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Identifies a specific AWS IoT SiteWise Monitor project.
type ProjectResource struct {
	_ struct{} `type:"structure"`

	// The ID of the project.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s ProjectResource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectResource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectResource"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProjectResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains project summary information.
type ProjectSummary struct {
	_ struct{} `type:"structure"`

	// The date the project was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The project's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the project.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the project was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The name of the project.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ProjectSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProjectSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateDate != nil {
		v := *s.LastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains asset property information.
type Property struct {
	_ struct{} `type:"structure"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The property data type.
	//
	// DataType is a required field
	DataType PropertyDataType `locationName:"dataType" type:"string" required:"true" enum:"true"`

	// The ID of the asset property.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The name of the property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The asset property's notification topic and state. For more information,
	// see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html)
	Notification *PropertyNotification `locationName:"notification" type:"structure"`

	// The property type (see PropertyType). A property contains one type.
	Type *PropertyType `locationName:"type" type:"structure"`

	// The unit (such as Newtons or RPM) of the asset property.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation
func (s Property) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Property) MarshalFields(e protocol.FieldEncoder) error {
	if s.Alias != nil {
		v := *s.Alias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "alias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DataType) > 0 {
		v := s.DataType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Notification != nil {
		v := s.Notification

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "notification", v, metadata)
	}
	if s.Type != nil {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "type", v, metadata)
	}
	if s.Unit != nil {
		v := *s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unit", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains asset property value notification information. When the notification
// state is enabled, AWS IoT SiteWise publishes property value updates to a
// unique MQTT topic. For more information, see Interacting with Other Services
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html)
// in the AWS IoT SiteWise User Guide.
type PropertyNotification struct {
	_ struct{} `type:"structure"`

	// The current notification state.
	//
	// State is a required field
	State PropertyNotificationState `locationName:"state" type:"string" required:"true" enum:"true"`

	// The MQTT topic to which AWS IoT SiteWise publishes property value update
	// notifications.
	//
	// Topic is a required field
	Topic *string `locationName:"topic" type:"string" required:"true"`
}

// String returns the string representation
func (s PropertyNotification) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PropertyNotification) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Topic != nil {
		v := *s.Topic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "topic", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains a property type, which can be one of attribute, measurement, metric,
// or transform.
type PropertyType struct {
	_ struct{} `type:"structure"`

	// Specifies an asset attribute property. An attribute generally contains static
	// information, such as the serial number of an IIoT (https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications)
	// wind turbine.
	Attribute *Attribute `locationName:"attribute" type:"structure"`

	// Specifies an asset measurement property. A measurement represents a device's
	// raw sensor data stream, such as timestamped temperature values or timestamped
	// power values.
	Measurement *Measurement `locationName:"measurement" type:"structure"`

	// Specifies an asset metric property. A metric contains a mathematical expression
	// that uses aggregate functions to process all input data points over a time
	// interval and output a single data point, such as to calculate the average
	// hourly temperature.
	Metric *Metric `locationName:"metric" type:"structure"`

	// Specifies an asset transform property. A transform contains a mathematical
	// expression that maps a property's data points from one form to another, such
	// as a unit conversion from Celsius to Fahrenheit.
	Transform *Transform `locationName:"transform" type:"structure"`
}

// String returns the string representation
func (s PropertyType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PropertyType"}
	if s.Attribute != nil {
		if err := s.Attribute.Validate(); err != nil {
			invalidParams.AddNested("Attribute", err.(aws.ErrInvalidParams))
		}
	}
	if s.Metric != nil {
		if err := s.Metric.Validate(); err != nil {
			invalidParams.AddNested("Metric", err.(aws.ErrInvalidParams))
		}
	}
	if s.Transform != nil {
		if err := s.Transform.Validate(); err != nil {
			invalidParams.AddNested("Transform", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PropertyType) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attribute != nil {
		v := s.Attribute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "attribute", v, metadata)
	}
	if s.Measurement != nil {
		v := s.Measurement

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "measurement", v, metadata)
	}
	if s.Metric != nil {
		v := s.Metric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metric", v, metadata)
	}
	if s.Transform != nil {
		v := s.Transform

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "transform", v, metadata)
	}
	return nil
}

// Contains a list of value updates for an asset property in the list of asset
// entries consumed by the BatchPutAssetPropertyValue (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html)
// API.
type PutAssetPropertyValueEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the asset to update.
	AssetId *string `locationName:"assetId" min:"36" type:"string"`

	// The user specified ID for the entry. You can use this ID to identify which
	// entries failed.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	PropertyAlias *string `locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property for this entry.
	PropertyId *string `locationName:"propertyId" min:"36" type:"string"`

	// The list of property values to upload. You can specify up to 10 propertyValues
	// array elements.
	//
	// PropertyValues is a required field
	PropertyValues []AssetPropertyValue `locationName:"propertyValues" type:"list" required:"true"`
}

// String returns the string representation
func (s PutAssetPropertyValueEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAssetPropertyValueEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutAssetPropertyValueEntry"}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetId", 36))
	}

	if s.EntryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EntryId"))
	}
	if s.EntryId != nil && len(*s.EntryId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EntryId", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("PropertyId", 36))
	}

	if s.PropertyValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("PropertyValues"))
	}
	if s.PropertyValues != nil {
		for i, v := range s.PropertyValues {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyValues", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutAssetPropertyValueEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EntryId != nil {
		v := *s.EntryId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entryId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PropertyAlias != nil {
		v := *s.PropertyAlias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "propertyAlias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PropertyId != nil {
		v := *s.PropertyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "propertyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PropertyValues != nil {
		v := s.PropertyValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "propertyValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Contains an AWS IoT SiteWise Monitor resource ID for a portal or project.
type Resource struct {
	_ struct{} `type:"structure"`

	// A portal resource.
	Portal *PortalResource `locationName:"portal" type:"structure"`

	// A project resource.
	Project *ProjectResource `locationName:"project" type:"structure"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Resource"}
	if s.Portal != nil {
		if err := s.Portal.Validate(); err != nil {
			invalidParams.AddNested("Portal", err.(aws.ErrInvalidParams))
		}
	}
	if s.Project != nil {
		if err := s.Project.Validate(); err != nil {
			invalidParams.AddNested("Project", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Resource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Portal != nil {
		v := s.Portal

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portal", v, metadata)
	}
	if s.Project != nil {
		v := s.Project

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "project", v, metadata)
	}
	return nil
}

// Contains a timestamp with optional nanosecond granularity.
type TimeInNanos struct {
	_ struct{} `type:"structure"`

	// The nanosecond offset from timeInSeconds.
	OffsetInNanos *int64 `locationName:"offsetInNanos" type:"integer"`

	// The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond
	// data is provided by offsetInNanos.
	//
	// TimeInSeconds is a required field
	TimeInSeconds *int64 `locationName:"timeInSeconds" min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s TimeInNanos) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeInNanos) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TimeInNanos"}

	if s.TimeInSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimeInSeconds"))
	}
	if s.TimeInSeconds != nil && *s.TimeInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TimeInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TimeInNanos) MarshalFields(e protocol.FieldEncoder) error {
	if s.OffsetInNanos != nil {
		v := *s.OffsetInNanos

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offsetInNanos", protocol.Int64Value(v), metadata)
	}
	if s.TimeInSeconds != nil {
		v := *s.TimeInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timeInSeconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Contains an asset transform property. A transform is a one-to-one mapping
// of a property's data points from one form to another. For example, you can
// use a transform to convert a Celsius data stream to Fahrenheit by applying
// the transformation expression to each data point of the Celsius stream. A
// transform can only have a data type of DOUBLE and consume properties with
// data types of INTEGER or DOUBLE.
//
// For more information, see Transforms (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#transforms)
// in the AWS IoT SiteWise User Guide.
type Transform struct {
	_ struct{} `type:"structure"`

	// The mathematical expression that defines the transformation function. You
	// can specify up to 10 variables per expression. You can specify up to 10 functions
	// per expression.
	//
	// For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The list of variables used in the expression.
	//
	// Variables is a required field
	Variables []ExpressionVariable `locationName:"variables" type:"list" required:"true"`
}

// String returns the string representation
func (s Transform) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Transform) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Transform"}

	if s.Expression == nil {
		invalidParams.Add(aws.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Expression", 1))
	}

	if s.Variables == nil {
		invalidParams.Add(aws.NewErrParamRequired("Variables"))
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Transform) MarshalFields(e protocol.FieldEncoder) error {
	if s.Expression != nil {
		v := *s.Expression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Variables != nil {
		v := s.Variables

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "variables", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Contains a tumbling window, which is a repeating fixed-sized, non-overlapping,
// and contiguous time interval. This window is used in metric and aggregation
// computations.
type TumblingWindow struct {
	_ struct{} `type:"structure"`

	// The time interval for the tumbling window. Note that w represents weeks,
	// d represents days, h represents hours, and m represents minutes. AWS IoT
	// SiteWise computes the 1w interval the end of Sunday at midnight each week
	// (UTC), the 1d interval at the end of each day at midnight (UTC), the 1h interval
	// at the end of each hour, and so on.
	//
	// When AWS IoT SiteWise aggregates data points for metric computations, the
	// start of each interval is exclusive and the end of each interval is inclusive.
	// AWS IoT SiteWise places the computed data point at the end of the interval.
	//
	// Interval is a required field
	Interval *string `locationName:"interval" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s TumblingWindow) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TumblingWindow) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TumblingWindow"}

	if s.Interval == nil {
		invalidParams.Add(aws.NewErrParamRequired("Interval"))
	}
	if s.Interval != nil && len(*s.Interval) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Interval", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TumblingWindow) MarshalFields(e protocol.FieldEncoder) error {
	if s.Interval != nil {
		v := *s.Interval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "interval", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information for a user identity in an access policy.
type UserIdentity struct {
	_ struct{} `type:"structure"`

	// The AWS SSO ID of the user.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UserIdentity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserIdentity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserIdentity"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserIdentity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Identifies a property value used in an expression.
type VariableValue struct {
	_ struct{} `type:"structure"`

	// The ID of the hierarchy to query for the property ID. You can use the hierarchy's
	// name instead of the hierarchy's ID.
	//
	// You use a hierarchy ID instead of a model ID because you can have several
	// hierarchies using the same model and therefore the same propertyId. For example,
	// you might have separately grouped assets that come from the same asset model.
	// For more information, see Asset Hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the AWS IoT SiteWise User Guide.
	HierarchyId *string `locationName:"hierarchyId" min:"1" type:"string"`

	// The ID of the property to use as the variable. You can use the property name
	// if it's from the same asset model.
	//
	// PropertyId is a required field
	PropertyId *string `locationName:"propertyId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VariableValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariableValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VariableValue"}
	if s.HierarchyId != nil && len(*s.HierarchyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HierarchyId", 1))
	}

	if s.PropertyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PropertyId"))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PropertyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VariableValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.HierarchyId != nil {
		v := *s.HierarchyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "hierarchyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PropertyId != nil {
		v := *s.PropertyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "propertyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains an asset property value (of a single type only).
type Variant struct {
	_ struct{} `type:"structure"`

	// Asset property data of type Boolean (true or false).
	BooleanValue *bool `locationName:"booleanValue" type:"boolean"`

	// Asset property data of type double (floating point number).
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// Asset property data of type integer (whole number).
	IntegerValue *int64 `locationName:"integerValue" type:"integer"`

	// Asset property data of type string (sequence of characters).
	StringValue *string `locationName:"stringValue" min:"1" type:"string"`
}

// String returns the string representation
func (s Variant) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Variant) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Variant"}
	if s.StringValue != nil && len(*s.StringValue) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StringValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Variant) MarshalFields(e protocol.FieldEncoder) error {
	if s.BooleanValue != nil {
		v := *s.BooleanValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "booleanValue", protocol.BoolValue(v), metadata)
	}
	if s.DoubleValue != nil {
		v := *s.DoubleValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "doubleValue", protocol.Float64Value(v), metadata)
	}
	if s.IntegerValue != nil {
		v := *s.IntegerValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integerValue", protocol.Int64Value(v), metadata)
	}
	if s.StringValue != nil {
		v := *s.StringValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stringValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
