// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateSystemTemplateInput struct {
	_ struct{} `type:"structure"`

	// The namespace version in which the system is to be created.
	//
	// If no value is specified, the latest version is used by default.
	CompatibleNamespaceVersion *int64 `locationName:"compatibleNamespaceVersion" type:"long"`

	// The DefinitionDocument used to create the system.
	//
	// Definition is a required field
	Definition *DefinitionDocument `locationName:"definition" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSystemTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSystemTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSystemTemplateInput"}

	if s.Definition == nil {
		invalidParams.Add(aws.NewErrParamRequired("Definition"))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateSystemTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The summary object that describes the created system.
	Summary *SystemTemplateSummary `locationName:"summary" type:"structure"`
}

// String returns the string representation
func (s CreateSystemTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateSystemTemplate = "CreateSystemTemplate"

// CreateSystemTemplateRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Creates a system. The system is validated against the entities in the latest
// version of the user's namespace unless another namespace version is specified
// in the request.
//
//    // Example sending a request using CreateSystemTemplateRequest.
//    req := client.CreateSystemTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemTemplate
func (c *Client) CreateSystemTemplateRequest(input *CreateSystemTemplateInput) CreateSystemTemplateRequest {
	op := &aws.Operation{
		Name:       opCreateSystemTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSystemTemplateInput{}
	}

	req := c.newRequest(op, input, &CreateSystemTemplateOutput{})

	return CreateSystemTemplateRequest{Request: req, Input: input, Copy: c.CreateSystemTemplateRequest}
}

// CreateSystemTemplateRequest is the request type for the
// CreateSystemTemplate API operation.
type CreateSystemTemplateRequest struct {
	*aws.Request
	Input *CreateSystemTemplateInput
	Copy  func(*CreateSystemTemplateInput) CreateSystemTemplateRequest
}

// Send marshals and sends the CreateSystemTemplate API request.
func (r CreateSystemTemplateRequest) Send(ctx context.Context) (*CreateSystemTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSystemTemplateResponse{
		CreateSystemTemplateOutput: r.Request.Data.(*CreateSystemTemplateOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSystemTemplateResponse is the response type for the
// CreateSystemTemplate API operation.
type CreateSystemTemplateResponse struct {
	*CreateSystemTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSystemTemplate request.
func (r *CreateSystemTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
