// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteSystemInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system instance to be deleted.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s DeleteSystemInstanceInput) String() string {
	return awsutil.Prettify(s)
}

type DeleteSystemInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSystemInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSystemInstance = "DeleteSystemInstance"

// DeleteSystemInstanceRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Deletes a system instance. Only system instances that have never been deployed,
// or that have been undeployed can be deleted.
//
// Users can create a new system instance that has the same ID as a deleted
// system instance.
//
//    // Example sending a request using DeleteSystemInstanceRequest.
//    req := client.DeleteSystemInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemInstance
func (c *Client) DeleteSystemInstanceRequest(input *DeleteSystemInstanceInput) DeleteSystemInstanceRequest {
	op := &aws.Operation{
		Name:       opDeleteSystemInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSystemInstanceInput{}
	}

	req := c.newRequest(op, input, &DeleteSystemInstanceOutput{})

	return DeleteSystemInstanceRequest{Request: req, Input: input, Copy: c.DeleteSystemInstanceRequest}
}

// DeleteSystemInstanceRequest is the request type for the
// DeleteSystemInstance API operation.
type DeleteSystemInstanceRequest struct {
	*aws.Request
	Input *DeleteSystemInstanceInput
	Copy  func(*DeleteSystemInstanceInput) DeleteSystemInstanceRequest
}

// Send marshals and sends the DeleteSystemInstance API request.
func (r DeleteSystemInstanceRequest) Send(ctx context.Context) (*DeleteSystemInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSystemInstanceResponse{
		DeleteSystemInstanceOutput: r.Request.Data.(*DeleteSystemInstanceOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSystemInstanceResponse is the response type for the
// DeleteSystemInstance API operation.
type DeleteSystemInstanceResponse struct {
	*DeleteSystemInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSystemInstance request.
func (r *DeleteSystemInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
