// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeprecateFlowTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the workflow to be deleted.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeprecateFlowTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeprecateFlowTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeprecateFlowTemplateInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeprecateFlowTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateFlowTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeprecateFlowTemplate = "DeprecateFlowTemplate"

// DeprecateFlowTemplateRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Deprecates the specified workflow. This action marks the workflow for deletion.
// Deprecated flows can't be deployed, but existing deployments will continue
// to run.
//
//    // Example sending a request using DeprecateFlowTemplateRequest.
//    req := client.DeprecateFlowTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateFlowTemplate
func (c *Client) DeprecateFlowTemplateRequest(input *DeprecateFlowTemplateInput) DeprecateFlowTemplateRequest {
	op := &aws.Operation{
		Name:       opDeprecateFlowTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprecateFlowTemplateInput{}
	}

	req := c.newRequest(op, input, &DeprecateFlowTemplateOutput{})

	return DeprecateFlowTemplateRequest{Request: req, Input: input, Copy: c.DeprecateFlowTemplateRequest}
}

// DeprecateFlowTemplateRequest is the request type for the
// DeprecateFlowTemplate API operation.
type DeprecateFlowTemplateRequest struct {
	*aws.Request
	Input *DeprecateFlowTemplateInput
	Copy  func(*DeprecateFlowTemplateInput) DeprecateFlowTemplateRequest
}

// Send marshals and sends the DeprecateFlowTemplate API request.
func (r DeprecateFlowTemplateRequest) Send(ctx context.Context) (*DeprecateFlowTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeprecateFlowTemplateResponse{
		DeprecateFlowTemplateOutput: r.Request.Data.(*DeprecateFlowTemplateOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeprecateFlowTemplateResponse is the response type for the
// DeprecateFlowTemplate API operation.
type DeprecateFlowTemplateResponse struct {
	*DeprecateFlowTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeprecateFlowTemplate request.
func (r *DeprecateFlowTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
