// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DissociateEntityFromThingInput struct {
	_ struct{} `type:"structure"`

	// The entity type from which to disassociate the thing.
	//
	// EntityType is a required field
	EntityType EntityType `locationName:"entityType" type:"string" required:"true" enum:"true"`

	// The name of the thing to disassociate.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DissociateEntityFromThingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DissociateEntityFromThingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DissociateEntityFromThingInput"}
	if len(s.EntityType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("EntityType"))
	}

	if s.ThingName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DissociateEntityFromThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DissociateEntityFromThingOutput) String() string {
	return awsutil.Prettify(s)
}

const opDissociateEntityFromThing = "DissociateEntityFromThing"

// DissociateEntityFromThingRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Dissociates a device entity from a concrete thing. The action takes only
// the type of the entity that you need to dissociate because only one entity
// of a particular type can be associated with a thing.
//
//    // Example sending a request using DissociateEntityFromThingRequest.
//    req := client.DissociateEntityFromThingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DissociateEntityFromThing
func (c *Client) DissociateEntityFromThingRequest(input *DissociateEntityFromThingInput) DissociateEntityFromThingRequest {
	op := &aws.Operation{
		Name:       opDissociateEntityFromThing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DissociateEntityFromThingInput{}
	}

	req := c.newRequest(op, input, &DissociateEntityFromThingOutput{})

	return DissociateEntityFromThingRequest{Request: req, Input: input, Copy: c.DissociateEntityFromThingRequest}
}

// DissociateEntityFromThingRequest is the request type for the
// DissociateEntityFromThing API operation.
type DissociateEntityFromThingRequest struct {
	*aws.Request
	Input *DissociateEntityFromThingInput
	Copy  func(*DissociateEntityFromThingInput) DissociateEntityFromThingRequest
}

// Send marshals and sends the DissociateEntityFromThing API request.
func (r DissociateEntityFromThingRequest) Send(ctx context.Context) (*DissociateEntityFromThingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DissociateEntityFromThingResponse{
		DissociateEntityFromThingOutput: r.Request.Data.(*DissociateEntityFromThingOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DissociateEntityFromThingResponse is the response type for the
// DissociateEntityFromThing API operation.
type DissociateEntityFromThingResponse struct {
	*DissociateEntityFromThingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DissociateEntityFromThing request.
func (r *DissociateEntityFromThingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
