// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SearchSystemInstancesInput struct {
	_ struct{} `type:"structure"`

	// Optional filter to apply to the search. Valid filters are SYSTEM_TEMPLATE_ID,
	// STATUS, and GREENGRASS_GROUP_NAME.
	//
	// Multiple filters function as OR criteria in the query. Multiple values passed
	// inside the filter function as AND criteria.
	Filters []SystemInstanceFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchSystemInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchSystemInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchSystemInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SearchSystemInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain summary data abour the system instances
	// in the result set.
	Summaries []SystemInstanceSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation
func (s SearchSystemInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearchSystemInstances = "SearchSystemInstances"

// SearchSystemInstancesRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Searches for system instances in the user's account.
//
//    // Example sending a request using SearchSystemInstancesRequest.
//    req := client.SearchSystemInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances
func (c *Client) SearchSystemInstancesRequest(input *SearchSystemInstancesInput) SearchSystemInstancesRequest {
	op := &aws.Operation{
		Name:       opSearchSystemInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchSystemInstancesInput{}
	}

	req := c.newRequest(op, input, &SearchSystemInstancesOutput{})

	return SearchSystemInstancesRequest{Request: req, Input: input, Copy: c.SearchSystemInstancesRequest}
}

// SearchSystemInstancesRequest is the request type for the
// SearchSystemInstances API operation.
type SearchSystemInstancesRequest struct {
	*aws.Request
	Input *SearchSystemInstancesInput
	Copy  func(*SearchSystemInstancesInput) SearchSystemInstancesRequest
}

// Send marshals and sends the SearchSystemInstances API request.
func (r SearchSystemInstancesRequest) Send(ctx context.Context) (*SearchSystemInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchSystemInstancesResponse{
		SearchSystemInstancesOutput: r.Request.Data.(*SearchSystemInstancesOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchSystemInstancesRequestPaginator returns a paginator for SearchSystemInstances.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchSystemInstancesRequest(input)
//   p := iotthingsgraph.NewSearchSystemInstancesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchSystemInstancesPaginator(req SearchSystemInstancesRequest) SearchSystemInstancesPaginator {
	return SearchSystemInstancesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchSystemInstancesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchSystemInstancesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchSystemInstancesPaginator struct {
	aws.Pager
}

func (p *SearchSystemInstancesPaginator) CurrentPage() *SearchSystemInstancesOutput {
	return p.Pager.CurrentPage().(*SearchSystemInstancesOutput)
}

// SearchSystemInstancesResponse is the response type for the
// SearchSystemInstances API operation.
type SearchSystemInstancesResponse struct {
	*SearchSystemInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchSystemInstances request.
func (r *SearchSystemInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
