// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateFlowTemplateInput struct {
	_ struct{} `type:"structure"`

	// The version of the user's namespace.
	//
	// If no value is specified, the latest version is used by default. Use the
	// GetFlowTemplateRevisions if you want to find earlier revisions of the flow
	// to update.
	CompatibleNamespaceVersion *int64 `locationName:"compatibleNamespaceVersion" type:"long"`

	// The DefinitionDocument that contains the updated workflow definition.
	//
	// Definition is a required field
	Definition *DefinitionDocument `locationName:"definition" type:"structure" required:"true"`

	// The ID of the workflow to be updated.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateFlowTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFlowTemplateInput"}

	if s.Definition == nil {
		invalidParams.Add(aws.NewErrParamRequired("Definition"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateFlowTemplateOutput struct {
	_ struct{} `type:"structure"`

	// An object containing summary information about the updated workflow.
	Summary *FlowTemplateSummary `locationName:"summary" type:"structure"`
}

// String returns the string representation
func (s UpdateFlowTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateFlowTemplate = "UpdateFlowTemplate"

// UpdateFlowTemplateRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Updates the specified workflow. All deployed systems and system instances
// that use the workflow will see the changes in the flow when it is redeployed.
// If you don't want this behavior, copy the workflow (creating a new workflow
// with a different ID), and update the copy. The workflow can contain only
// entities in the specified namespace.
//
//    // Example sending a request using UpdateFlowTemplateRequest.
//    req := client.UpdateFlowTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateFlowTemplate
func (c *Client) UpdateFlowTemplateRequest(input *UpdateFlowTemplateInput) UpdateFlowTemplateRequest {
	op := &aws.Operation{
		Name:       opUpdateFlowTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFlowTemplateInput{}
	}

	req := c.newRequest(op, input, &UpdateFlowTemplateOutput{})

	return UpdateFlowTemplateRequest{Request: req, Input: input, Copy: c.UpdateFlowTemplateRequest}
}

// UpdateFlowTemplateRequest is the request type for the
// UpdateFlowTemplate API operation.
type UpdateFlowTemplateRequest struct {
	*aws.Request
	Input *UpdateFlowTemplateInput
	Copy  func(*UpdateFlowTemplateInput) UpdateFlowTemplateRequest
}

// Send marshals and sends the UpdateFlowTemplate API request.
func (r UpdateFlowTemplateRequest) Send(ctx context.Context) (*UpdateFlowTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateFlowTemplateResponse{
		UpdateFlowTemplateOutput: r.Request.Data.(*UpdateFlowTemplateOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateFlowTemplateResponse is the response type for the
// UpdateFlowTemplate API operation.
type UpdateFlowTemplateResponse struct {
	*UpdateFlowTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateFlowTemplate request.
func (r *UpdateFlowTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
