// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type BatchGetStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// Array of ARNs, one per channel.
	//
	// Arns is a required field
	Arns []string `locationName:"arns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetStreamKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetStreamKeyInput"}

	if s.Arns == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arns"))
	}
	if s.Arns != nil && len(s.Arns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Arns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetStreamKeyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Arns != nil {
		v := s.Arns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "arns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type BatchGetStreamKeyOutput struct {
	_ struct{} `type:"structure"`

	Errors []BatchError `locationName:"errors" type:"list"`

	StreamKeys []StreamKey `locationName:"streamKeys" type:"list"`
}

// String returns the string representation
func (s BatchGetStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetStreamKeyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.StreamKeys != nil {
		v := s.StreamKeys

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "streamKeys", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opBatchGetStreamKey = "BatchGetStreamKey"

// BatchGetStreamKeyRequest returns a request value for making API operation for
// Amazon Interactive Video Service.
//
// Performs GetStreamKey on multiple ARNs simultaneously.
//
//    // Example sending a request using BatchGetStreamKeyRequest.
//    req := client.BatchGetStreamKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetStreamKey
func (c *Client) BatchGetStreamKeyRequest(input *BatchGetStreamKeyInput) BatchGetStreamKeyRequest {
	op := &aws.Operation{
		Name:       opBatchGetStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchGetStreamKey",
	}

	if input == nil {
		input = &BatchGetStreamKeyInput{}
	}

	req := c.newRequest(op, input, &BatchGetStreamKeyOutput{})

	return BatchGetStreamKeyRequest{Request: req, Input: input, Copy: c.BatchGetStreamKeyRequest}
}

// BatchGetStreamKeyRequest is the request type for the
// BatchGetStreamKey API operation.
type BatchGetStreamKeyRequest struct {
	*aws.Request
	Input *BatchGetStreamKeyInput
	Copy  func(*BatchGetStreamKeyInput) BatchGetStreamKeyRequest
}

// Send marshals and sends the BatchGetStreamKey API request.
func (r BatchGetStreamKeyRequest) Send(ctx context.Context) (*BatchGetStreamKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetStreamKeyResponse{
		BatchGetStreamKeyOutput: r.Request.Data.(*BatchGetStreamKeyOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetStreamKeyResponse is the response type for the
// BatchGetStreamKey API operation.
type BatchGetStreamKeyResponse struct {
	*BatchGetStreamKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetStreamKey request.
func (r *BatchGetStreamKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
