// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel for which to create the stream key.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// See Channel$tags.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateStreamKeyInput"}

	if s.ChannelArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChannelArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateStreamKeyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChannelArn != nil {
		v := *s.ChannelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateStreamKeyOutput struct {
	_ struct{} `type:"structure"`

	// Stream key used to authenticate an RTMP stream for ingestion.
	StreamKey *StreamKey `locationName:"streamKey" type:"structure"`
}

// String returns the string representation
func (s CreateStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateStreamKeyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.StreamKey != nil {
		v := s.StreamKey

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "streamKey", v, metadata)
	}
	return nil
}

const opCreateStreamKey = "CreateStreamKey"

// CreateStreamKeyRequest returns a request value for making API operation for
// Amazon Interactive Video Service.
//
// Creates a stream key, used to initiate a stream, for a specified channel
// ARN.
//
// Note that CreateChannel creates a stream key. If you subsequently use CreateStreamKey
// on the same channel, it will fail because a stream key already exists and
// there is a limit of 1 stream key per channel. To reset the stream key on
// a channel, use DeleteStreamKey and then CreateStreamKey.
//
//    // Example sending a request using CreateStreamKeyRequest.
//    req := client.CreateStreamKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateStreamKey
func (c *Client) CreateStreamKeyRequest(input *CreateStreamKeyInput) CreateStreamKeyRequest {
	op := &aws.Operation{
		Name:       opCreateStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateStreamKey",
	}

	if input == nil {
		input = &CreateStreamKeyInput{}
	}

	req := c.newRequest(op, input, &CreateStreamKeyOutput{})

	return CreateStreamKeyRequest{Request: req, Input: input, Copy: c.CreateStreamKeyRequest}
}

// CreateStreamKeyRequest is the request type for the
// CreateStreamKey API operation.
type CreateStreamKeyRequest struct {
	*aws.Request
	Input *CreateStreamKeyInput
	Copy  func(*CreateStreamKeyInput) CreateStreamKeyRequest
}

// Send marshals and sends the CreateStreamKey API request.
func (r CreateStreamKeyRequest) Send(ctx context.Context) (*CreateStreamKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateStreamKeyResponse{
		CreateStreamKeyOutput: r.Request.Data.(*CreateStreamKeyOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateStreamKeyResponse is the response type for the
// CreateStreamKey API operation.
type CreateStreamKeyResponse struct {
	*CreateStreamKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateStreamKey request.
func (r *CreateStreamKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
