// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteStreamKeyInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stream key to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStreamKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteStreamKeyInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteStreamKeyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteStreamKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteStreamKeyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteStreamKey = "DeleteStreamKey"

// DeleteStreamKeyRequest returns a request value for making API operation for
// Amazon Interactive Video Service.
//
// Deletes the stream key for a specified ARN, so it can no longer be used to
// stream.
//
//    // Example sending a request using DeleteStreamKeyRequest.
//    req := client.DeleteStreamKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteStreamKey
func (c *Client) DeleteStreamKeyRequest(input *DeleteStreamKeyInput) DeleteStreamKeyRequest {
	op := &aws.Operation{
		Name:       opDeleteStreamKey,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteStreamKey",
	}

	if input == nil {
		input = &DeleteStreamKeyInput{}
	}

	req := c.newRequest(op, input, &DeleteStreamKeyOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteStreamKeyRequest{Request: req, Input: input, Copy: c.DeleteStreamKeyRequest}
}

// DeleteStreamKeyRequest is the request type for the
// DeleteStreamKey API operation.
type DeleteStreamKeyRequest struct {
	*aws.Request
	Input *DeleteStreamKeyInput
	Copy  func(*DeleteStreamKeyInput) DeleteStreamKeyRequest
}

// Send marshals and sends the DeleteStreamKey API request.
func (r DeleteStreamKeyRequest) Send(ctx context.Context) (*DeleteStreamKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteStreamKeyResponse{
		DeleteStreamKeyOutput: r.Request.Data.(*DeleteStreamKeyOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteStreamKeyResponse is the response type for the
// DeleteStreamKey API operation.
type DeleteStreamKeyResponse struct {
	*DeleteStreamKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteStreamKey request.
func (r *DeleteStreamKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
