// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetChannelInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel for which the configuration is to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetChannelInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetChannelOutput struct {
	_ struct{} `type:"structure"`

	// Object specifying a channel.
	Channel *Channel `locationName:"channel" type:"structure"`
}

// String returns the string representation
func (s GetChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Channel != nil {
		v := s.Channel

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "channel", v, metadata)
	}
	return nil
}

const opGetChannel = "GetChannel"

// GetChannelRequest returns a request value for making API operation for
// Amazon Interactive Video Service.
//
// Gets the channel configuration for a specified channel ARN. See also BatchGetChannel.
//
//    // Example sending a request using GetChannelRequest.
//    req := client.GetChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetChannel
func (c *Client) GetChannelRequest(input *GetChannelInput) GetChannelRequest {
	op := &aws.Operation{
		Name:       opGetChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/GetChannel",
	}

	if input == nil {
		input = &GetChannelInput{}
	}

	req := c.newRequest(op, input, &GetChannelOutput{})

	return GetChannelRequest{Request: req, Input: input, Copy: c.GetChannelRequest}
}

// GetChannelRequest is the request type for the
// GetChannel API operation.
type GetChannelRequest struct {
	*aws.Request
	Input *GetChannelInput
	Copy  func(*GetChannelInput) GetChannelRequest
}

// Send marshals and sends the GetChannel API request.
func (r GetChannelRequest) Send(ctx context.Context) (*GetChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetChannelResponse{
		GetChannelOutput: r.Request.Data.(*GetChannelOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetChannelResponse is the response type for the
// GetChannel API operation.
type GetChannelResponse struct {
	*GetChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetChannel request.
func (r *GetChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
