// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Error related to a specific channel, specified by its ARN.
type BatchError struct {
	_ struct{} `type:"structure"`

	// Channel ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Error code.
	Code *string `locationName:"code" type:"string"`

	// Error message, determined by the application.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BatchError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchError) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Code != nil {
		v := *s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "code", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Object specifying a channel.
type Channel struct {
	_ struct{} `type:"structure"`

	// Channel ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Channel ingest endpoint, part of the definition of an ingest server, used
	// when you set up streaming software.
	IngestEndpoint *string `locationName:"ingestEndpoint" type:"string"`

	// Channel latency mode. Default: LOW.
	LatencyMode ChannelLatencyMode `locationName:"latencyMode" type:"string" enum:"true"`

	// Channel name.
	Name *string `locationName:"name" type:"string"`

	// Channel playback URL.
	PlaybackUrl *string `locationName:"playbackUrl" type:"string"`

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string `locationName:"tags" type:"map"`

	// Channel type, which determines the allowable resolution and bitrate. STANDARD:
	// The stream is transcoded; resolution (width, in landscape orientation) can
	// be up to 1080p or the input source resolution, whichever is lower; and bitrate
	// can be up to 8.5 Mbps. BASIC: The stream is transfixed; resolution can be
	// up to 480p; and bitrate can be up to 1.5 Mbps. Default STANDARD.
	Type ChannelType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Channel) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IngestEndpoint != nil {
		v := *s.IngestEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ingestEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.LatencyMode) > 0 {
		v := s.LatencyMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "latencyMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PlaybackUrl != nil {
		v := *s.PlaybackUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "playbackUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Summary information about a channel.
type ChannelSummary struct {
	_ struct{} `type:"structure"`

	// Channel ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Channel latency mode. Default: LOW.
	LatencyMode ChannelLatencyMode `locationName:"latencyMode" type:"string" enum:"true"`

	// Channel name.
	Name *string `locationName:"name" type:"string"`

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.LatencyMode) > 0 {
		v := s.LatencyMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "latencyMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Specifies a live video stream that has been ingested and distributed.
type Stream struct {
	_ struct{} `type:"structure"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// The stream’s health.
	Health StreamHealth `locationName:"health" type:"string" enum:"true"`

	// URL of the video master manifest, required by the video player to play the
	// HLS stream.
	PlaybackUrl *string `locationName:"playbackUrl" type:"string"`

	// ISO-8601 formatted timestamp of the stream’s start.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The stream’s state.
	State StreamState `locationName:"state" type:"string" enum:"true"`

	// Number of current viewers of the stream.
	ViewerCount *int64 `locationName:"viewerCount" type:"long"`
}

// String returns the string representation
func (s Stream) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Stream) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChannelArn != nil {
		v := *s.ChannelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Health) > 0 {
		v := s.Health

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "health", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PlaybackUrl != nil {
		v := *s.PlaybackUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "playbackUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ViewerCount != nil {
		v := *s.ViewerCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "viewerCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Object specifying a stream key.
type StreamKey struct {
	_ struct{} `type:"structure"`

	// Stream-key ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// Array of 1-50 maps, each of the form string:string (key:value)
	Tags map[string]string `locationName:"tags" type:"map"`

	// Stream-key value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s StreamKey) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamKey) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChannelArn != nil {
		v := *s.ChannelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Summary information about a stream key.
type StreamKeySummary struct {
	_ struct{} `type:"structure"`

	// Stream-key ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// Array of 1-50 maps, each of the form string:string (key:value)
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s StreamKeySummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamKeySummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChannelArn != nil {
		v := *s.ChannelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Summary information about a stream.
type StreamSummary struct {
	_ struct{} `type:"structure"`

	// Channel ARN for the stream.
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string"`

	// The stream’s health.
	Health StreamHealth `locationName:"health" type:"string" enum:"true"`

	// ISO-8601 formatted timestamp of the stream’s start.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The stream’s state.
	State StreamState `locationName:"state" type:"string" enum:"true"`

	// Number of current viewers of the stream.
	ViewerCount *int64 `locationName:"viewerCount" type:"long"`
}

// String returns the string representation
func (s StreamSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChannelArn != nil {
		v := *s.ChannelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Health) > 0 {
		v := s.Health

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "health", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ViewerCount != nil {
		v := *s.ViewerCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "viewerCount", protocol.Int64Value(v), metadata)
	}
	return nil
}
