// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ivsiface provides an interface to enable mocking the Amazon Interactive Video Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ivsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/ivs"
)

// ClientAPI provides an interface to enable mocking the
// ivs.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon IVS.
//    func myFunc(svc ivsiface.ClientAPI) bool {
//        // Make svc.BatchGetChannel request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := ivs.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        ivsiface.ClientPI
//    }
//    func (m *mockClientClient) BatchGetChannel(input *ivs.BatchGetChannelInput) (*ivs.BatchGetChannelOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	BatchGetChannelRequest(*ivs.BatchGetChannelInput) ivs.BatchGetChannelRequest

	BatchGetStreamKeyRequest(*ivs.BatchGetStreamKeyInput) ivs.BatchGetStreamKeyRequest

	CreateChannelRequest(*ivs.CreateChannelInput) ivs.CreateChannelRequest

	CreateStreamKeyRequest(*ivs.CreateStreamKeyInput) ivs.CreateStreamKeyRequest

	DeleteChannelRequest(*ivs.DeleteChannelInput) ivs.DeleteChannelRequest

	DeleteStreamKeyRequest(*ivs.DeleteStreamKeyInput) ivs.DeleteStreamKeyRequest

	GetChannelRequest(*ivs.GetChannelInput) ivs.GetChannelRequest

	GetStreamRequest(*ivs.GetStreamInput) ivs.GetStreamRequest

	GetStreamKeyRequest(*ivs.GetStreamKeyInput) ivs.GetStreamKeyRequest

	ListChannelsRequest(*ivs.ListChannelsInput) ivs.ListChannelsRequest

	ListStreamKeysRequest(*ivs.ListStreamKeysInput) ivs.ListStreamKeysRequest

	ListStreamsRequest(*ivs.ListStreamsInput) ivs.ListStreamsRequest

	ListTagsForResourceRequest(*ivs.ListTagsForResourceInput) ivs.ListTagsForResourceRequest

	PutMetadataRequest(*ivs.PutMetadataInput) ivs.PutMetadataRequest

	StopStreamRequest(*ivs.StopStreamInput) ivs.StopStreamRequest

	TagResourceRequest(*ivs.TagResourceInput) ivs.TagResourceRequest

	UntagResourceRequest(*ivs.UntagResourceInput) ivs.UntagResourceRequest

	UpdateChannelRequest(*ivs.UpdateChannelInput) ivs.UpdateChannelRequest
}

var _ ClientAPI = (*ivs.Client)(nil)
