// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kafka

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	CurrentVersion *string `location:"querystring" locationName:"currentVersion" type:"string"`
}

// String returns the string representation
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteClusterInput"}

	if s.ClusterArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteClusterInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ClusterArn != nil {
		v := *s.ClusterArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "clusterArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CurrentVersion != nil {
		v := *s.CurrentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "currentVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Returns information about the deleted cluster.
type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
	State ClusterState `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteClusterOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClusterArn != nil {
		v := *s.ClusterArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clusterArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest returns a request value for making API operation for
// Managed Streaming for Kafka.
//
// Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the
// request.
//
//    // Example sending a request using DeleteClusterRequest.
//    req := client.DeleteClusterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteCluster
func (c *Client) DeleteClusterRequest(input *DeleteClusterInput) DeleteClusterRequest {
	op := &aws.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/clusters/{clusterArn}",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	req := c.newRequest(op, input, &DeleteClusterOutput{})

	return DeleteClusterRequest{Request: req, Input: input, Copy: c.DeleteClusterRequest}
}

// DeleteClusterRequest is the request type for the
// DeleteCluster API operation.
type DeleteClusterRequest struct {
	*aws.Request
	Input *DeleteClusterInput
	Copy  func(*DeleteClusterInput) DeleteClusterRequest
}

// Send marshals and sends the DeleteCluster API request.
func (r DeleteClusterRequest) Send(ctx context.Context) (*DeleteClusterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteClusterResponse{
		DeleteClusterOutput: r.Request.Data.(*DeleteClusterOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteClusterResponse is the response type for the
// DeleteCluster API operation.
type DeleteClusterResponse struct {
	*DeleteClusterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCluster request.
func (r *DeleteClusterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
