// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kafka

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListKafkaVersionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListKafkaVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKafkaVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListKafkaVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListKafkaVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Response for ListKafkaVersions.
type ListKafkaVersionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Kafka version objects.
	KafkaVersions []KafkaVersion `locationName:"kafkaVersions" type:"list"`

	// Paginated results marker.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListKafkaVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListKafkaVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.KafkaVersions != nil {
		v := s.KafkaVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "kafkaVersions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListKafkaVersions = "ListKafkaVersions"

// ListKafkaVersionsRequest returns a request value for making API operation for
// Managed Streaming for Kafka.
//
// Returns a list of Kafka versions.
//
//    // Example sending a request using ListKafkaVersionsRequest.
//    req := client.ListKafkaVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions
func (c *Client) ListKafkaVersionsRequest(input *ListKafkaVersionsInput) ListKafkaVersionsRequest {
	op := &aws.Operation{
		Name:       opListKafkaVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/kafka-versions",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKafkaVersionsInput{}
	}

	req := c.newRequest(op, input, &ListKafkaVersionsOutput{})

	return ListKafkaVersionsRequest{Request: req, Input: input, Copy: c.ListKafkaVersionsRequest}
}

// ListKafkaVersionsRequest is the request type for the
// ListKafkaVersions API operation.
type ListKafkaVersionsRequest struct {
	*aws.Request
	Input *ListKafkaVersionsInput
	Copy  func(*ListKafkaVersionsInput) ListKafkaVersionsRequest
}

// Send marshals and sends the ListKafkaVersions API request.
func (r ListKafkaVersionsRequest) Send(ctx context.Context) (*ListKafkaVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListKafkaVersionsResponse{
		ListKafkaVersionsOutput: r.Request.Data.(*ListKafkaVersionsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListKafkaVersionsRequestPaginator returns a paginator for ListKafkaVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListKafkaVersionsRequest(input)
//   p := kafka.NewListKafkaVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListKafkaVersionsPaginator(req ListKafkaVersionsRequest) ListKafkaVersionsPaginator {
	return ListKafkaVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListKafkaVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListKafkaVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListKafkaVersionsPaginator struct {
	aws.Pager
}

func (p *ListKafkaVersionsPaginator) CurrentPage() *ListKafkaVersionsOutput {
	return p.Pager.CurrentPage().(*ListKafkaVersionsOutput)
}

// ListKafkaVersionsResponse is the response type for the
// ListKafkaVersions API operation.
type ListKafkaVersionsResponse struct {
	*ListKafkaVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListKafkaVersions request.
func (r *ListKafkaVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
