// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateFaqInput struct {
	_ struct{} `type:"structure"`

	// A description of the FAQ.
	Description *string `min:"1" type:"string"`

	// The identifier of the index that contains the FAQ.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The name that should be associated with the FAQ.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a role with permission to access the S3
	// bucket that contains the FAQs. For more information, see IAM Roles for Amazon
	// Kendra (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The S3 location of the FAQ input data.
	//
	// S3Path is a required field
	S3Path *S3Path `type:"structure" required:"true"`

	// A list of key-value pairs that identify the FAQ. You can use the tags to
	// identify and organize your resources and to control access to resources.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateFaqInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFaqInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFaqInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.IndexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexId", 36))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}

	if s.S3Path == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Path"))
	}
	if s.S3Path != nil {
		if err := s.S3Path.Validate(); err != nil {
			invalidParams.AddNested("S3Path", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateFaqOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the FAQ.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateFaqOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateFaq = "CreateFaq"

// CreateFaqRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Creates an new set of frequently asked question (FAQ) questions and answers.
//
//    // Example sending a request using CreateFaqRequest.
//    req := client.CreateFaqRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateFaq
func (c *Client) CreateFaqRequest(input *CreateFaqInput) CreateFaqRequest {
	op := &aws.Operation{
		Name:       opCreateFaq,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFaqInput{}
	}

	req := c.newRequest(op, input, &CreateFaqOutput{})

	return CreateFaqRequest{Request: req, Input: input, Copy: c.CreateFaqRequest}
}

// CreateFaqRequest is the request type for the
// CreateFaq API operation.
type CreateFaqRequest struct {
	*aws.Request
	Input *CreateFaqInput
	Copy  func(*CreateFaqInput) CreateFaqRequest
}

// Send marshals and sends the CreateFaq API request.
func (r CreateFaqRequest) Send(ctx context.Context) (*CreateFaqResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateFaqResponse{
		CreateFaqOutput: r.Request.Data.(*CreateFaqOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateFaqResponse is the response type for the
// CreateFaq API operation.
type CreateFaqResponse struct {
	*CreateFaqOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateFaq request.
func (r *CreateFaqResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
