// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeFaqInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the FAQ.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the FAQ.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFaqInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFaqInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeFaqInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if s.IndexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeFaqOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the FAQ was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the FAQ that you provided when it was created.
	Description *string `min:"1" type:"string"`

	// If the Status field is FAILED, the ErrorMessage field contains the reason
	// why the FAQ failed.
	ErrorMessage *string `min:"1" type:"string"`

	// The identifier of the FAQ.
	Id *string `min:"1" type:"string"`

	// The identifier of the index that contains the FAQ.
	IndexId *string `min:"36" type:"string"`

	// The name that you gave the FAQ when it was created.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role that provides access to the S3
	// bucket containing the input files for the FAQ.
	RoleArn *string `min:"1" type:"string"`

	// Information required to find a specific file in an Amazon S3 bucket.
	S3Path *S3Path `type:"structure"`

	// The status of the FAQ. It is ready to use when the status is ACTIVE.
	Status FaqStatus `type:"string" enum:"true"`

	// The date and time that the FAQ was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeFaqOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeFaq = "DescribeFaq"

// DescribeFaqRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Gets information about an FAQ list.
//
//    // Example sending a request using DescribeFaqRequest.
//    req := client.DescribeFaqRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeFaq
func (c *Client) DescribeFaqRequest(input *DescribeFaqInput) DescribeFaqRequest {
	op := &aws.Operation{
		Name:       opDescribeFaq,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFaqInput{}
	}

	req := c.newRequest(op, input, &DescribeFaqOutput{})

	return DescribeFaqRequest{Request: req, Input: input, Copy: c.DescribeFaqRequest}
}

// DescribeFaqRequest is the request type for the
// DescribeFaq API operation.
type DescribeFaqRequest struct {
	*aws.Request
	Input *DescribeFaqInput
	Copy  func(*DescribeFaqInput) DescribeFaqRequest
}

// Send marshals and sends the DescribeFaq API request.
func (r DescribeFaqRequest) Send(ctx context.Context) (*DescribeFaqResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeFaqResponse{
		DescribeFaqOutput: r.Request.Data.(*DescribeFaqOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeFaqResponse is the response type for the
// DescribeFaq API operation.
type DescribeFaqResponse struct {
	*DescribeFaqOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeFaq request.
func (r *DescribeFaqResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
