// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Access Control List files for the documents in a data source.
type AccessControlListConfiguration struct {
	_ struct{} `type:"structure"`

	// Path to the AWS S3 bucket that contains the ACL files.
	KeyPath *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AccessControlListConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlListConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccessControlListConfiguration"}
	if s.KeyPath != nil && len(*s.KeyPath) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyPath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about the column that should be used for filtering the
// query response by groups.
type AclConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of groups, separated by semi-colons, that filters a query response
	// based on user context. The document is only returned to users that are in
	// one of the groups specified in the UserContext field of the Query operation.
	//
	// AllowedGroupsColumnName is a required field
	AllowedGroupsColumnName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AclConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AclConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AclConfiguration"}

	if s.AllowedGroupsColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AllowedGroupsColumnName"))
	}
	if s.AllowedGroupsColumnName != nil && len(*s.AllowedGroupsColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AllowedGroupsColumnName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An attribute returned from an index query.
type AdditionalResultAttribute struct {
	_ struct{} `type:"structure"`

	// The key that identifies the attribute.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// An object that contains the attribute value.
	//
	// Value is a required field
	Value *AdditionalResultAttributeValue `type:"structure" required:"true"`

	// The data type of the Value property.
	//
	// ValueType is a required field
	ValueType AdditionalResultAttributeValueType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AdditionalResultAttribute) String() string {
	return awsutil.Prettify(s)
}

// An attribute returned with a document from a search.
type AdditionalResultAttributeValue struct {
	_ struct{} `type:"structure"`

	// The text associated with the attribute and information about the highlight
	// to apply to the text.
	TextWithHighlightsValue *TextWithHighlights `type:"structure"`
}

// String returns the string representation
func (s AdditionalResultAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// Provides filtering the query results based on document attributes.
//
// When you use the AndAllFilters or OrAllFilters, filters you can use 2 layers
// under the first attribute filter. For example, you can use:
//
// <AndAllFilters>
//
// <OrAllFilters>
//
// <EqualTo>
//
// If you use more than 2 layers, you receive a ValidationException exception
// with the message "AttributeFilter cannot have a depth of more than 2."
type AttributeFilter struct {
	_ struct{} `type:"structure"`

	// Performs a logical AND operation on all supplied filters.
	AndAllFilters []AttributeFilter `type:"list"`

	// Returns true when a document contains all of the specified document attributes.
	// This filter is only appicable to StringListValue metadata.
	ContainsAll *DocumentAttribute `type:"structure"`

	// Returns true when a document contains any of the specified document attributes.This
	// filter is only appicable to StringListValue metadata.
	ContainsAny *DocumentAttribute `type:"structure"`

	// Performs an equals operation on two document attributes.
	EqualsTo *DocumentAttribute `type:"structure"`

	// Performs a greater than operation on two document attributes. Use with a
	// document attribute of type Integer or Long.
	GreaterThan *DocumentAttribute `type:"structure"`

	// Performs a greater or equals than operation on two document attributes. Use
	// with a document attribute of type Integer or Long.
	GreaterThanOrEquals *DocumentAttribute `type:"structure"`

	// Performs a less than operation on two document attributes. Use with a document
	// attribute of type Integer or Long.
	LessThan *DocumentAttribute `type:"structure"`

	// Performs a less than or equals operation on two document attributes. Use
	// with a document attribute of type Integer or Long.
	LessThanOrEquals *DocumentAttribute `type:"structure"`

	// Performs a logical NOT operation on all supplied filters.
	NotFilter *AttributeFilter `type:"structure"`

	// Performs a logical OR operation on all supplied filters.
	OrAllFilters []AttributeFilter `type:"list"`
}

// String returns the string representation
func (s AttributeFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttributeFilter"}
	if s.ContainsAll != nil {
		if err := s.ContainsAll.Validate(); err != nil {
			invalidParams.AddNested("ContainsAll", err.(aws.ErrInvalidParams))
		}
	}
	if s.ContainsAny != nil {
		if err := s.ContainsAny.Validate(); err != nil {
			invalidParams.AddNested("ContainsAny", err.(aws.ErrInvalidParams))
		}
	}
	if s.EqualsTo != nil {
		if err := s.EqualsTo.Validate(); err != nil {
			invalidParams.AddNested("EqualsTo", err.(aws.ErrInvalidParams))
		}
	}
	if s.GreaterThan != nil {
		if err := s.GreaterThan.Validate(); err != nil {
			invalidParams.AddNested("GreaterThan", err.(aws.ErrInvalidParams))
		}
	}
	if s.GreaterThanOrEquals != nil {
		if err := s.GreaterThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("GreaterThanOrEquals", err.(aws.ErrInvalidParams))
		}
	}
	if s.LessThan != nil {
		if err := s.LessThan.Validate(); err != nil {
			invalidParams.AddNested("LessThan", err.(aws.ErrInvalidParams))
		}
	}
	if s.LessThanOrEquals != nil {
		if err := s.LessThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("LessThanOrEquals", err.(aws.ErrInvalidParams))
		}
	}
	if s.NotFilter != nil {
		if err := s.NotFilter.Validate(); err != nil {
			invalidParams.AddNested("NotFilter", err.(aws.ErrInvalidParams))
		}
	}
	if s.OrAllFilters != nil {
		for i, v := range s.OrAllFilters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrAllFilters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about documents that could not be removed from an index
// by the BatchDeleteDocument operation.
type BatchDeleteDocumentResponseFailedDocument struct {
	_ struct{} `type:"structure"`

	// The error code for why the document couldn't be removed from the index.
	ErrorCode ErrorCode `type:"string" enum:"true"`

	// An explanation for why the document couldn't be removed from the index.
	ErrorMessage *string `min:"1" type:"string"`

	// The identifier of the document that couldn't be removed from the index.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchDeleteDocumentResponseFailedDocument) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a document that could not be indexed.
type BatchPutDocumentResponseFailedDocument struct {
	_ struct{} `type:"structure"`

	// The type of error that caused the document to fail to be indexed.
	ErrorCode ErrorCode `type:"string" enum:"true"`

	// A description of the reason why the document could not be indexed.
	ErrorMessage *string `min:"1" type:"string"`

	// The unique identifier of the document.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchPutDocumentResponseFailedDocument) String() string {
	return awsutil.Prettify(s)
}

// Specifies capacity units configured for your index. You can add and remove
// capacity units to tune an index to your requirements.
type CapacityUnitsConfiguration struct {
	_ struct{} `type:"structure"`

	// The amount of extra query capacity for an index. Each capacity unit provides
	// 0.5 queries per second and 40,000 queries per day.
	//
	// QueryCapacityUnits is a required field
	QueryCapacityUnits *int64 `type:"integer" required:"true"`

	// The amount of extra storage capacity for an index. Each capacity unit provides
	// 150 Gb of storage space or 500,000 documents, whichever is reached first.
	//
	// StorageCapacityUnits is a required field
	StorageCapacityUnits *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CapacityUnitsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacityUnitsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CapacityUnitsConfiguration"}

	if s.QueryCapacityUnits == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueryCapacityUnits"))
	}

	if s.StorageCapacityUnits == nil {
		invalidParams.Add(aws.NewErrParamRequired("StorageCapacityUnits"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Gathers information about when a particular result was clicked by a user.
// Your application uses the SubmitFeedback operation to provide click information.
type ClickFeedback struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp of the date and time that the result was clicked.
	//
	// ClickTime is a required field
	ClickTime *time.Time `type:"timestamp" required:"true"`

	// The unique identifier of the search result that was clicked.
	//
	// ResultId is a required field
	ResultId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ClickFeedback) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClickFeedback) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ClickFeedback"}

	if s.ClickTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClickTime"))
	}

	if s.ResultId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResultId"))
	}
	if s.ResultId != nil && len(*s.ResultId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResultId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about how Amazon Kendra should use the columns of a
// database in an index.
type ColumnConfiguration struct {
	_ struct{} `type:"structure"`

	// One to five columns that indicate when a document in the database has changed.
	//
	// ChangeDetectingColumns is a required field
	ChangeDetectingColumns []string `min:"1" type:"list" required:"true"`

	// The column that contains the contents of the document.
	//
	// DocumentDataColumnName is a required field
	DocumentDataColumnName *string `min:"1" type:"string" required:"true"`

	// The column that provides the document's unique identifier.
	//
	// DocumentIdColumnName is a required field
	DocumentIdColumnName *string `min:"1" type:"string" required:"true"`

	// The column that contains the title of the document.
	DocumentTitleColumnName *string `min:"1" type:"string"`

	// An array of objects that map database column names to the corresponding fields
	// in an index. You must first create the fields in the index using the UpdateIndex
	// operation.
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`
}

// String returns the string representation
func (s ColumnConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ColumnConfiguration"}

	if s.ChangeDetectingColumns == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeDetectingColumns"))
	}
	if s.ChangeDetectingColumns != nil && len(s.ChangeDetectingColumns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeDetectingColumns", 1))
	}

	if s.DocumentDataColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentDataColumnName"))
	}
	if s.DocumentDataColumnName != nil && len(*s.DocumentDataColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentDataColumnName", 1))
	}

	if s.DocumentIdColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentIdColumnName"))
	}
	if s.DocumentIdColumnName != nil && len(*s.DocumentIdColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentIdColumnName", 1))
	}
	if s.DocumentTitleColumnName != nil && len(*s.DocumentTitleColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentTitleColumnName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the information necessary to connect to a database.
type ConnectionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the host for the database. Can be either a string (host.subdomain.domain.tld)
	// or an IPv4 or IPv6 address.
	//
	// DatabaseHost is a required field
	DatabaseHost *string `min:"1" type:"string" required:"true"`

	// The name of the database containing the document data.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The port that the database uses for connections.
	//
	// DatabasePort is a required field
	DatabasePort *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager.
	// The credentials should be a user/password pair. For more information, see
	// Using a Database Data Source (https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html).
	// For more information about AWS Secrets Manager, see What Is AWS Secrets Manager
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	// in the AWS Secrets Manager user guide.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The name of the table that contains the document data.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConnectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConnectionConfiguration"}

	if s.DatabaseHost == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseHost"))
	}
	if s.DatabaseHost != nil && len(*s.DatabaseHost) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseHost", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.DatabasePort == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabasePort"))
	}
	if s.DatabasePort != nil && *s.DatabasePort < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("DatabasePort", 1))
	}

	if s.SecretArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretArn", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration information for a Amazon Kendra data source.
type DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides information necessary to create a connector for a database.
	DatabaseConfiguration *DatabaseConfiguration `type:"structure"`

	// Provided configuration for data sources that connect to Microsoft OneDrive.
	OneDriveConfiguration *OneDriveConfiguration `type:"structure"`

	// Provides information to create a connector for a document repository in an
	// Amazon S3 bucket.
	S3Configuration *S3DataSourceConfiguration `type:"structure"`

	// Provides configuration information for data sources that connect to a Salesforce
	// site.
	SalesforceConfiguration *SalesforceConfiguration `type:"structure"`

	// Provides configuration for data sources that connect to ServiceNow instances.
	ServiceNowConfiguration *ServiceNowConfiguration `type:"structure"`

	// Provides information necessary to create a connector for a Microsoft SharePoint
	// site.
	SharePointConfiguration *SharePointConfiguration `type:"structure"`
}

// String returns the string representation
func (s DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSourceConfiguration"}
	if s.DatabaseConfiguration != nil {
		if err := s.DatabaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DatabaseConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.OneDriveConfiguration != nil {
		if err := s.OneDriveConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OneDriveConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(aws.ErrInvalidParams))
		}
	}
	if s.SalesforceConfiguration != nil {
		if err := s.SalesforceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SalesforceConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.ServiceNowConfiguration != nil {
		if err := s.ServiceNowConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServiceNowConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.SharePointConfiguration != nil {
		if err := s.SharePointConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SharePointConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Summary information for a Amazon Kendra data source. Returned in a call to .
type DataSourceSummary struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime that the data source was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The unique identifier for the data source.
	Id *string `min:"1" type:"string"`

	// The name of the data source.
	Name *string `min:"1" type:"string"`

	// The status of the data source. When the status is ATIVE the data source is
	// ready to use.
	Status DataSourceStatus `type:"string" enum:"true"`

	// The type of the data source.
	Type DataSourceType `type:"string" enum:"true"`

	// The UNIX datetime that the data source was lasted updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DataSourceSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a synchronization job.
type DataSourceSyncJob struct {
	_ struct{} `type:"structure"`

	// If the reason that the synchronization failed is due to an error with the
	// underlying data source, this field contains a code that identifies the error.
	DataSourceErrorCode *string `min:"1" type:"string"`

	// The UNIX datetime that the synchronization job was completed.
	EndTime *time.Time `type:"timestamp"`

	// If the Status field is set to FAILED, the ErrorCode field contains a the
	// reason that the synchronization failed.
	ErrorCode ErrorCode `type:"string" enum:"true"`

	// If the Status field is set to ERROR, the ErrorMessage field contains a description
	// of the error that caused the synchronization to fail.
	ErrorMessage *string `min:"1" type:"string"`

	// A unique identifier for the synchronization job.
	ExecutionId *string `min:"1" type:"string"`

	// Maps a batch delete document request to a specific data source sync job.
	// This is optional and should only be supplied when documents are deleted by
	// a connector.
	Metrics *DataSourceSyncJobMetrics `type:"structure"`

	// The UNIX datetime that the synchronization job was started.
	StartTime *time.Time `type:"timestamp"`

	// The execution status of the synchronization job. When the Status field is
	// set to SUCCEEDED, the synchronization job is done. If the status code is
	// set to FAILED, the ErrorCode and ErrorMessage fields give you the reason
	// for the failure.
	Status DataSourceSyncJobStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DataSourceSyncJob) String() string {
	return awsutil.Prettify(s)
}

// Maps a particular data source sync job to a particular data source.
type DataSourceSyncJobMetricTarget struct {
	_ struct{} `type:"structure"`

	// The ID of the data source that is running the sync job.
	//
	// DataSourceId is a required field
	DataSourceId *string `min:"1" type:"string" required:"true"`

	// The ID of the sync job that is running on the data source.
	//
	// DataSourceSyncJobId is a required field
	DataSourceSyncJobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DataSourceSyncJobMetricTarget) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceSyncJobMetricTarget) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSourceSyncJobMetricTarget"}

	if s.DataSourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataSourceId", 1))
	}

	if s.DataSourceSyncJobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSourceSyncJobId"))
	}
	if s.DataSourceSyncJobId != nil && len(*s.DataSourceSyncJobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataSourceSyncJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Maps a batch delete document request to a specific data source sync job.
// This is optional and should only be supplied when documents are deleted by
// a connector.
type DataSourceSyncJobMetrics struct {
	_ struct{} `type:"structure"`

	// The number of documents added from the data source up to now in the data
	// source sync.
	DocumentsAdded *string `type:"string"`

	// The number of documents deleted from the data source up to now in the data
	// source sync run.
	DocumentsDeleted *string `type:"string"`

	// The number of documents that failed to sync from the data source up to now
	// in the data source sync run.
	DocumentsFailed *string `type:"string"`

	// The number of documents modified in the data source up to now in the data
	// source sync run.
	DocumentsModified *string `type:"string"`

	// The current number of documents crawled by the current sync job in the data
	// source.
	DocumentsScanned *string `type:"string"`
}

// String returns the string representation
func (s DataSourceSyncJobMetrics) String() string {
	return awsutil.Prettify(s)
}

// Maps a column or attribute in the data source to an index field. You must
// first create the fields in the index using the UpdateIndex operation.
type DataSourceToIndexFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the column or attribute in the data source.
	//
	// DataSourceFieldName is a required field
	DataSourceFieldName *string `min:"1" type:"string" required:"true"`

	// The type of data stored in the column or attribute.
	DateFieldFormat *string `min:"4" type:"string"`

	// The name of the field in the index.
	//
	// IndexFieldName is a required field
	IndexFieldName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DataSourceToIndexFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceToIndexFieldMapping) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSourceToIndexFieldMapping"}

	if s.DataSourceFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSourceFieldName"))
	}
	if s.DataSourceFieldName != nil && len(*s.DataSourceFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataSourceFieldName", 1))
	}
	if s.DateFieldFormat != nil && len(*s.DateFieldFormat) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("DateFieldFormat", 4))
	}

	if s.IndexFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexFieldName"))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexFieldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information for connecting to an Amazon VPC.
type DataSourceVpcConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of identifiers of security groups within your Amazon VPC. The security
	// groups should enable Amazon Kendra to connect to the data source.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []string `min:"1" type:"list" required:"true"`

	// A list of identifiers for subnets within your Amazon VPC. The subnets should
	// be able to connect to each other in the VPC, and they should have outgoing
	// access to the Internet through a NAT device.
	//
	// SubnetIds is a required field
	SubnetIds []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DataSourceVpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceVpcConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSourceVpcConfiguration"}

	if s.SecurityGroupIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityGroupIds", 1))
	}

	if s.SubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SubnetIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the information necessary to connect a database to an index.
type DatabaseConfiguration struct {
	_ struct{} `type:"structure"`

	// Information about the database column that provides information for user
	// context filtering.
	AclConfiguration *AclConfiguration `type:"structure"`

	// Information about where the index should get the document information from
	// the database.
	//
	// ColumnConfiguration is a required field
	ColumnConfiguration *ColumnConfiguration `type:"structure" required:"true"`

	// The information necessary to connect to a database.
	//
	// ConnectionConfiguration is a required field
	ConnectionConfiguration *ConnectionConfiguration `type:"structure" required:"true"`

	// The type of database engine that runs the database.
	//
	// DatabaseEngineType is a required field
	DatabaseEngineType DatabaseEngineType `type:"string" required:"true" enum:"true"`

	// Provides information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s DatabaseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatabaseConfiguration"}

	if s.ColumnConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnConfiguration"))
	}

	if s.ConnectionConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionConfiguration"))
	}
	if len(s.DatabaseEngineType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseEngineType"))
	}
	if s.AclConfiguration != nil {
		if err := s.AclConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AclConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.ColumnConfiguration != nil {
		if err := s.ColumnConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ColumnConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.ConnectionConfiguration != nil {
		if err := s.ConnectionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ConnectionConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A document in an index.
type Document struct {
	_ struct{} `type:"structure"`

	// Information to use for user context filtering.
	AccessControlList []Principal `type:"list"`

	// Custom attributes to apply to the document. Use the custom attributes to
	// provide additional information for searching, to provide facets for refining
	// searches, and to provide additional information in the query response.
	Attributes []DocumentAttribute `type:"list"`

	// The contents of the document.
	//
	// Documents passed to the Blob parameter must be base64 encoded. Your code
	// might not need to encode the document file bytes if you're using an AWS SDK
	// to call Amazon Kendra operations. If you are calling the Amazon Kendra endpoint
	// directly using REST, you must base64 encode the contents before sending.
	//
	// Blob is automatically base64 encoded/decoded by the SDK.
	Blob []byte `type:"blob"`

	// The file type of the document in the Blob field.
	ContentType ContentType `type:"string" enum:"true"`

	// A unique identifier of the document in the index.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Information required to find a specific file in an Amazon S3 bucket.
	S3Path *S3Path `type:"structure"`

	// The title of the document.
	Title *string `type:"string"`
}

// String returns the string representation
func (s Document) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Document) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Document"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}
	if s.AccessControlList != nil {
		for i, v := range s.AccessControlList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlList", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.S3Path != nil {
		if err := s.S3Path.Validate(); err != nil {
			invalidParams.AddNested("S3Path", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A custom attribute value assigned to a document.
type DocumentAttribute struct {
	_ struct{} `type:"structure"`

	// The identifier for the attribute.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the attribute.
	//
	// Value is a required field
	Value *DocumentAttributeValue `type:"structure" required:"true"`
}

// String returns the string representation
func (s DocumentAttribute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttribute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentAttribute"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The value of a custom document attribute. You can only provide one value
// for a custom attribute.
type DocumentAttributeValue struct {
	_ struct{} `type:"structure"`

	// A date value expressed as seconds from the Unix epoch.
	DateValue *time.Time `type:"timestamp"`

	// A long integer value.
	LongValue *int64 `type:"long"`

	// A list of strings.
	StringListValue []string `type:"list"`

	// A string, such as "department".
	StringValue *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DocumentAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttributeValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentAttributeValue"}
	if s.StringValue != nil && len(*s.StringValue) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StringValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the count of documents that match a particular attribute when doing
// a faceted search.
type DocumentAttributeValueCountPair struct {
	_ struct{} `type:"structure"`

	// The number of documents in the response that have the attribute value for
	// the key.
	Count *int64 `type:"integer"`

	// The value of the attribute. For example, "HR."
	DocumentAttributeValue *DocumentAttributeValue `type:"structure"`
}

// String returns the string representation
func (s DocumentAttributeValueCountPair) String() string {
	return awsutil.Prettify(s)
}

// Specifies the properties of a custom index field.
type DocumentMetadataConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the index field.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Provides manual tuning parameters to determine how the field affects the
	// search results.
	Relevance *Relevance `type:"structure"`

	// Provides information about how the field is used during a search.
	Search *Search `type:"structure"`

	// The data type of the index field.
	//
	// Type is a required field
	Type DocumentAttributeValueType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DocumentMetadataConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentMetadataConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentMetadataConfiguration"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Relevance != nil {
		if err := s.Relevance.Validate(); err != nil {
			invalidParams.AddNested("Relevance", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Document metadata files that contain information such as the document access
// control information, source URI, document author, and custom attributes.
// Each metadata file contains metadata about a single document.
type DocumentsMetadataConfiguration struct {
	_ struct{} `type:"structure"`

	// A prefix used to filter metadata configuration files in the AWS S3 bucket.
	// The S3 bucket might contain multiple metadata files. Use S3Prefix to include
	// only the desired metadata files.
	S3Prefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DocumentsMetadataConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentsMetadataConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentsMetadataConfiguration"}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a document attribute
type Facet struct {
	_ struct{} `type:"structure"`

	// The unique key for the document attribute.
	DocumentAttributeKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Facet) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Facet) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Facet"}
	if s.DocumentAttributeKey != nil && len(*s.DocumentAttributeKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentAttributeKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The facet values for the documents in the response.
type FacetResult struct {
	_ struct{} `type:"structure"`

	// The key for the facet values. This is the same as the DocumentAttributeKey
	// provided in the query.
	DocumentAttributeKey *string `min:"1" type:"string"`

	// An array of key/value pairs, where the key is the value of the attribute
	// and the count is the number of documents that share the key value.
	DocumentAttributeValueCountPairs []DocumentAttributeValueCountPair `type:"list"`
}

// String returns the string representation
func (s FacetResult) String() string {
	return awsutil.Prettify(s)
}

// Provides statistical information about the FAQ questions and answers contained
// in an index.
type FaqStatistics struct {
	_ struct{} `type:"structure"`

	// The total number of FAQ questions and answers contained in the index.
	//
	// IndexedQuestionAnswersCount is a required field
	IndexedQuestionAnswersCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FaqStatistics) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a frequently asked questions and answer contained
// in an index.
type FaqSummary struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime that the FAQ was added to the index.
	CreatedAt *time.Time `type:"timestamp"`

	// The unique identifier of the FAQ.
	Id *string `min:"1" type:"string"`

	// The name that you assigned the FAQ when you created or updated the FAQ.
	Name *string `min:"1" type:"string"`

	// The current status of the FAQ. When the status is ACTIVE the FAQ is ready
	// for use.
	Status FaqStatus `type:"string" enum:"true"`

	// The UNIX datetime that the FAQ was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s FaqSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides information that you can use to highlight a search result so that
// your users can quickly identify terms in the response.
type Highlight struct {
	_ struct{} `type:"structure"`

	// The zero-based location in the response string where the highlight starts.
	//
	// BeginOffset is a required field
	BeginOffset *int64 `type:"integer" required:"true"`

	// The zero-based location in the response string where the highlight ends.
	//
	// EndOffset is a required field
	EndOffset *int64 `type:"integer" required:"true"`

	// Indicates whether the response is the best response. True if this is the
	// best response; otherwise, false.
	TopAnswer *bool `type:"boolean"`
}

// String returns the string representation
func (s Highlight) String() string {
	return awsutil.Prettify(s)
}

// A summary of information about an index.
type IndexConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp when the index was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// Indicates whether the index is a enterprise edition index or a developer
	// edition index.
	Edition IndexEdition `type:"string" enum:"true"`

	// A unique identifier for the index. Use this to identify the index when you
	// are using operations such as Query, DescribeIndex, UpdateIndex, and DeleteIndex.
	Id *string `min:"36" type:"string"`

	// The name of the index.
	Name *string `min:"1" type:"string"`

	// The current status of the index. When the status is ACTIVE, the index is
	// ready to search.
	//
	// Status is a required field
	Status IndexStatus `type:"string" required:"true" enum:"true"`

	// The Unix timestamp when the index was last updated by the UpdateIndex operation.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s IndexConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides information about the number of documents and the number of questions
// and answers in an index.
type IndexStatistics struct {
	_ struct{} `type:"structure"`

	// The number of question and answer topics in the index.
	//
	// FaqStatistics is a required field
	FaqStatistics *FaqStatistics `type:"structure" required:"true"`

	// The number of text documents indexed.
	//
	// TextDocumentStatistics is a required field
	TextDocumentStatistics *TextDocumentStatistics `type:"structure" required:"true"`
}

// String returns the string representation
func (s IndexStatistics) String() string {
	return awsutil.Prettify(s)
}

// Provides configuration information for data sources that connect to OneDrive.
type OneDriveConfiguration struct {
	_ struct{} `type:"structure"`

	// List of regular expressions applied to documents. Items that match the exclusion
	// pattern are not indexed. If you provide both an inclusion pattern and an
	// exclusion pattern, any item that matches the exclusion pattern isn't indexed.
	//
	// The exclusion pattern is applied to the file name.
	ExclusionPatterns []string `type:"list"`

	// A list of DataSourceToIndexFieldMapping objects that map Microsoft OneDrive
	// fields to custom fields in the Amazon Kendra index. You must first create
	// the index fields before you map OneDrive fields.
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// A list of regular expression patterns. Documents that match the pattern are
	// included in the index. Documents that don't match the pattern are excluded
	// from the index. If a document matches both an inclusion pattern and an exclusion
	// pattern, the document is not included in the index.
	//
	// The exclusion pattern is applied to the file name.
	InclusionPatterns []string `type:"list"`

	// A list of user accounts whose documents should be indexed.
	//
	// OneDriveUsers is a required field
	OneDriveUsers *OneDriveUsers `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains
	// the user name and password to connect to OneDrive. The user namd should be
	// the application ID for the OneDrive application, and the password is the
	// application key for the OneDrive application.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// Tha Azure Active Directory domain of the organization.
	//
	// TenantDomain is a required field
	TenantDomain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s OneDriveConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OneDriveConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OneDriveConfiguration"}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}

	if s.OneDriveUsers == nil {
		invalidParams.Add(aws.NewErrParamRequired("OneDriveUsers"))
	}

	if s.SecretArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretArn", 1))
	}

	if s.TenantDomain == nil {
		invalidParams.Add(aws.NewErrParamRequired("TenantDomain"))
	}
	if s.TenantDomain != nil && len(*s.TenantDomain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TenantDomain", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OneDriveUsers != nil {
		if err := s.OneDriveUsers.Validate(); err != nil {
			invalidParams.AddNested("OneDriveUsers", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// User accounts whose documents should be indexed.
type OneDriveUsers struct {
	_ struct{} `type:"structure"`

	// A list of users whose documents should be indexed. Specify the user names
	// in email format, for example, username@tenantdomain. If you need to index
	// the documents of more than 100 users, use the OneDriveUserS3Path field to
	// specify the location of a file containing a list of users.
	OneDriveUserList []string `min:"1" type:"list"`

	// The S3 bucket location of a file containing a list of users whose documents
	// should be indexed.
	OneDriveUserS3Path *S3Path `type:"structure"`
}

// String returns the string representation
func (s OneDriveUsers) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OneDriveUsers) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OneDriveUsers"}
	if s.OneDriveUserList != nil && len(s.OneDriveUserList) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OneDriveUserList", 1))
	}
	if s.OneDriveUserS3Path != nil {
		if err := s.OneDriveUserS3Path.Validate(); err != nil {
			invalidParams.AddNested("OneDriveUserS3Path", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides user and group information for document access filtering.
type Principal struct {
	_ struct{} `type:"structure"`

	// Whether to allow or deny access to the principal.
	//
	// Access is a required field
	Access ReadAccessType `type:"string" required:"true" enum:"true"`

	// The name of the user or group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The type of principal.
	//
	// Type is a required field
	Type PrincipalType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Principal) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Principal) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Principal"}
	if len(s.Access) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Access"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A single query result.
//
// A query result contains information about a document returned by the query.
// This includes the original location of the document, a list of attributes
// assigned to the document, and relevant text from the document that satisfies
// the query.
type QueryResultItem struct {
	_ struct{} `type:"structure"`

	// One or more additional attribues associated with the query result.
	AdditionalAttributes []AdditionalResultAttribute `type:"list"`

	// An array of document attributes for the document that the query result maps
	// to. For example, the document author (Author) or the source URI (SourceUri)
	// of the document.
	DocumentAttributes []DocumentAttribute `type:"list"`

	// An extract of the text in the document. Contains information about highlighting
	// the relevant terms in the excerpt.
	DocumentExcerpt *TextWithHighlights `type:"structure"`

	// The unique identifier for the document.
	DocumentId *string `min:"1" type:"string"`

	// The title of the document. Contains the text of the title and information
	// for highlighting the relevant terms in the title.
	DocumentTitle *TextWithHighlights `type:"structure"`

	// The URI of the original location of the document.
	DocumentURI *string `min:"1" type:"string"`

	// The unique identifier for the query result.
	Id *string `min:"1" type:"string"`

	// The type of document.
	Type QueryResultType `type:"string" enum:"true"`
}

// String returns the string representation
func (s QueryResultItem) String() string {
	return awsutil.Prettify(s)
}

// Provides information for manually tuning the relevance of a field in a search.
// When a query includes terms that match the field, the results are given a
// boost in the response based on these tuning parameters.
type Relevance struct {
	_ struct{} `type:"structure"`

	// Specifies the time period that the boost applies to. For example, to make
	// the boost apply to documents with the field value within the last month,
	// you would use "2628000s". Once the field value is beyond the specified range,
	// the effect of the boost drops off. The higher the importance, the faster
	// the effect drops off. If you don't specify a value, the default is 3 months.
	// The value of the field is a numeric string followed by the character "s",
	// for example "86400s" for one day, or "604800s" for one week.
	//
	// Only applies to DATE fields.
	Duration *string `min:"1" type:"string"`

	// Indicates that this field determines how "fresh" a document is. For example,
	// if document 1 was created on November 5, and document 2 was created on October
	// 31, document 1 is "fresher" than document 2. You can only set the Freshness
	// field on one DATE type field. Only applies to DATE fields.
	Freshness *bool `type:"boolean"`

	// The relative importance of the field in the search. Larger numbers provide
	// more of a boost than smaller numbers.
	Importance *int64 `min:"1" type:"integer"`

	// Determines how values should be interpreted.
	//
	// When the RankOrder field is ASCENDING, higher numbers are better. For example,
	// a document with a rating score of 10 is higher ranking than a document with
	// a rating score of 1.
	//
	// When the RankOrder field is DESCENDING, lower numbers are better. For example,
	// in a task tracking application, a priority 1 task is more important than
	// a priority 5 task.
	//
	// Only applies to LONG and DOUBLE fields.
	RankOrder Order `type:"string" enum:"true"`

	// A list of values that should be given a different boost when they appear
	// in the result list. For example, if you are boosting a field called "department,"
	// query terms that match the department field are boosted in the result. However,
	// you can add entries from the department field to boost documents with those
	// values higher.
	//
	// For example, you can add entries to the map with names of departments. If
	// you add "HR",5 and "Legal",3 those departments are given special attention
	// when they appear in the metadata of a document. When those terms appear they
	// are given the specified importance instead of the regular importance for
	// the boost.
	ValueImportanceMap map[string]int64 `type:"map"`
}

// String returns the string representation
func (s Relevance) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Relevance) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Relevance"}
	if s.Duration != nil && len(*s.Duration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Duration", 1))
	}
	if s.Importance != nil && *s.Importance < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Importance", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides feedback on how relevant a document is to a search. Your application
// uses the SubmitFeedback operation to provide relevance information.
type RelevanceFeedback struct {
	_ struct{} `type:"structure"`

	// Whether to document was relevant or not relevant to the search.
	//
	// RelevanceValue is a required field
	RelevanceValue RelevanceType `type:"string" required:"true" enum:"true"`

	// The unique identifier of the search result that the user provided relevance
	// feedback for.
	//
	// ResultId is a required field
	ResultId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RelevanceFeedback) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelevanceFeedback) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RelevanceFeedback"}
	if len(s.RelevanceValue) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RelevanceValue"))
	}

	if s.ResultId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResultId"))
	}
	if s.ResultId != nil && len(*s.ResultId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResultId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for a data source to index documents in
// an Amazon S3 bucket.
type S3DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides the path to the S3 bucket that contains the user context filtering
	// files for the data source.
	AccessControlListConfiguration *AccessControlListConfiguration `type:"structure"`

	// The name of the bucket that contains the documents.
	//
	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	// Document metadata files that contain information such as the document access
	// control information, source URI, document author, and custom attributes.
	// Each metadata file contains metadata about a single document.
	DocumentsMetadataConfiguration *DocumentsMetadataConfiguration `type:"structure"`

	// A list of glob patterns for documents that should not be indexed. If a document
	// that matches an inclusion prefix also matches an exclusion pattern, the document
	// is not indexed.
	//
	// For more information about glob patterns, see glob (programming) (https://en.wikipedia.org/wiki/Glob_(programming))
	// in Wikipedia.
	ExclusionPatterns []string `type:"list"`

	// A list of S3 prefixes for the documents that should be included in the index.
	InclusionPrefixes []string `type:"list"`
}

// String returns the string representation
func (s S3DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataSourceConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3DataSourceConfiguration"}

	if s.BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketName", 3))
	}
	if s.AccessControlListConfiguration != nil {
		if err := s.AccessControlListConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AccessControlListConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.DocumentsMetadataConfiguration != nil {
		if err := s.DocumentsMetadataConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DocumentsMetadataConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information required to find a specific file in an Amazon S3 bucket.
type S3Path struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket that contains the file.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The name of the file.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Path) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Path) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Path"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 3))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines configuration for syncing a Salesforce chatter feed. The contents
// of the object comes from the Salesforce FeedItem table.
type SalesforceChatterFeedConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the column in the Salesforce FeedItem table that contains the
	// content to index. Typically this is the Body column.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the column in the Salesforce FeedItem table that contains the
	// title of the document. This is typically the Title collumn.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// Filters the documents in the feed based on status of the user. When you specify
	// ACTIVE_USERS only documents from users who have an active account are indexed.
	// When you specify STANDARD_USER only documents for Salesforce standard users
	// are documented. You can specify both.
	IncludeFilterTypes []SalesforceChatterFeedIncludeFilterType `min:"1" type:"list"`
}

// String returns the string representation
func (s SalesforceChatterFeedConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceChatterFeedConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SalesforceChatterFeedConfiguration"}

	if s.DocumentDataFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.IncludeFilterTypes != nil && len(s.IncludeFilterTypes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IncludeFilterTypes", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for connecting to a Salesforce data source.
type SalesforceConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies configuration information for Salesforce chatter feeds.
	ChatterFeedConfiguration *SalesforceChatterFeedConfiguration `type:"structure"`

	// Indicates whether Amazon Kendra should index attachments to Salesforce objects.
	CrawlAttachments *bool `type:"boolean"`

	// A list of regular expression patterns. Documents that match the patterns
	// are excluded from the index. Documents that don't match the patterns are
	// included in the index. If a document matches both an exclusion pattern and
	// an inclusion pattern, the document is not included in the index.
	//
	// The regex is applied to the name of the attached file.
	ExcludeAttachmentFilePatterns []string `type:"list"`

	// A list of regular expression patterns. Documents that match the patterns
	// are included in the index. Documents that don't match the patterns are excluded
	// from the index. If a document matches both an inclusion pattern and an exclusion
	// pattern, the document is not included in the index.
	//
	// The regex is applied to the name of the attached file.
	IncludeAttachmentFilePatterns []string `type:"list"`

	// Specifies configuration information for the knowlege article types that Amazon
	// Kendra indexes. Amazon Kendra indexes standard knowledge articles and the
	// standard fields of knowledge articles, or the custom fields of custom knowledge
	// articles, but not both.
	KnowledgeArticleConfiguration *SalesforceKnowledgeArticleConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains
	// the key/value pairs required to connect to your Salesforce instance. The
	// secret must contain a JSON structure with the following keys:
	//
	//    * authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to
	//    get an OAUTH token.
	//
	//    * consumerKey - The application public key generated when you created
	//    your Salesforce application.
	//
	//    * consumerSecret - The application private key generated when you created
	//    your Salesforce application.
	//
	//    * password - The password associated with the user logging in to the Salesforce
	//    instance.
	//
	//    * securityToken - The token associated with the user account logging in
	//    to the Salesforce instance.
	//
	//    * username - The user name of the user logging in to the Salesforce instance.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The instance URL for the Salesforce site that you want to index.
	//
	// ServerUrl is a required field
	ServerUrl *string `min:"1" type:"string" required:"true"`

	// Provides configuration information for processing attachments to Salesforce
	// standard objects.
	StandardObjectAttachmentConfiguration *SalesforceStandardObjectAttachmentConfiguration `type:"structure"`

	// Specifies the Salesforce standard objects that Amazon Kendra indexes.
	StandardObjectConfigurations []SalesforceStandardObjectConfiguration `min:"1" type:"list"`
}

// String returns the string representation
func (s SalesforceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SalesforceConfiguration"}

	if s.SecretArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretArn", 1))
	}

	if s.ServerUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerUrl"))
	}
	if s.ServerUrl != nil && len(*s.ServerUrl) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerUrl", 1))
	}
	if s.StandardObjectConfigurations != nil && len(s.StandardObjectConfigurations) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StandardObjectConfigurations", 1))
	}
	if s.ChatterFeedConfiguration != nil {
		if err := s.ChatterFeedConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChatterFeedConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.KnowledgeArticleConfiguration != nil {
		if err := s.KnowledgeArticleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KnowledgeArticleConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.StandardObjectAttachmentConfiguration != nil {
		if err := s.StandardObjectAttachmentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StandardObjectAttachmentConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.StandardObjectConfigurations != nil {
		for i, v := range s.StandardObjectConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StandardObjectConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for indexing Salesforce custom articles.
type SalesforceCustomKnowledgeArticleTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the field in the custom knowledge article that contains the document
	// data to index.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the field in the custom knowledge article that contains the document
	// title.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// One or more objects that map fields in the custom knowledge article to fields
	// in the Amazon Kendra index.
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// The name of the configuration.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SalesforceCustomKnowledgeArticleTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceCustomKnowledgeArticleTypeConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SalesforceCustomKnowledgeArticleTypeConfiguration"}

	if s.DocumentDataFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies configuration information for the knowlege article types that Amazon
// Kendra indexes. Amazon Kendra indexes standard knowledge articles and the
// standard fields of knowledge articles, or the custom fields of custom knowledge
// articles, but not both
type SalesforceKnowledgeArticleConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides configuration information for custom Salesforce knowledge articles.
	CustomKnowledgeArticleTypeConfigurations []SalesforceCustomKnowledgeArticleTypeConfiguration `min:"1" type:"list"`

	// Specifies the document states that should be included when Amazon Kendra
	// indexes knowledge articles. You must specify at least one state.
	//
	// IncludedStates is a required field
	IncludedStates []SalesforceKnowledgeArticleState `min:"1" type:"list" required:"true"`

	// Provides configuration information for standard Salesforce knowledge articles.
	StandardKnowledgeArticleTypeConfiguration *SalesforceStandardKnowledgeArticleTypeConfiguration `type:"structure"`
}

// String returns the string representation
func (s SalesforceKnowledgeArticleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceKnowledgeArticleConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SalesforceKnowledgeArticleConfiguration"}
	if s.CustomKnowledgeArticleTypeConfigurations != nil && len(s.CustomKnowledgeArticleTypeConfigurations) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CustomKnowledgeArticleTypeConfigurations", 1))
	}

	if s.IncludedStates == nil {
		invalidParams.Add(aws.NewErrParamRequired("IncludedStates"))
	}
	if s.IncludedStates != nil && len(s.IncludedStates) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IncludedStates", 1))
	}
	if s.CustomKnowledgeArticleTypeConfigurations != nil {
		for i, v := range s.CustomKnowledgeArticleTypeConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomKnowledgeArticleTypeConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.StandardKnowledgeArticleTypeConfiguration != nil {
		if err := s.StandardKnowledgeArticleTypeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StandardKnowledgeArticleTypeConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for standard Salesforce knowledge articles.
type SalesforceStandardKnowledgeArticleTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the field that contains the document data to index.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the field that contains the document title.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// One or more objects that map fields in the knowledge article to Amazon Kendra
	// index fields. The index field must exist before you can map a Salesforce
	// field to it.
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`
}

// String returns the string representation
func (s SalesforceStandardKnowledgeArticleTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceStandardKnowledgeArticleTypeConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SalesforceStandardKnowledgeArticleTypeConfiguration"}

	if s.DocumentDataFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for processing attachments to Salesforce
// standard objects.
type SalesforceStandardObjectAttachmentConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the field used for the document title.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// One or more objects that map fields in attachments to Amazon Kendra index
	// fields.
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`
}

// String returns the string representation
func (s SalesforceStandardObjectAttachmentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceStandardObjectAttachmentConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SalesforceStandardObjectAttachmentConfiguration"}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies confguration information for indexing a single standard object.
type SalesforceStandardObjectConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the field in the standard object table that contains the document
	// contents.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the field in the standard object table that contains the document
	// titleB.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// One or more objects that map fields in the standard object to Amazon Kendra
	// index fields. The index field must exist before you can map a Salesforce
	// field to it.
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// The name of the standard object.
	//
	// Name is a required field
	Name SalesforceStandardObjectName `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SalesforceStandardObjectConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceStandardObjectConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SalesforceStandardObjectConfiguration"}

	if s.DocumentDataFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about how a custom index field is used during a search.
type Search struct {
	_ struct{} `type:"structure"`

	// Determines whether the field is returned in the query response. The default
	// is true.
	Displayable *bool `type:"boolean"`

	// Indicates that the field can be used to create search facets, a count of
	// results for each value in the field. The default is false .
	Facetable *bool `type:"boolean"`

	// Determines whether the field is used in the search. If the Searchable field
	// is true, you can use relevance tuning to manually tune how Amazon Kendra
	// weights the field in the search. The default is true for string fields and
	// false for number and date fields.
	Searchable *bool `type:"boolean"`
}

// String returns the string representation
func (s Search) String() string {
	return awsutil.Prettify(s)
}

// Provides the identifier of the AWS KMS customer master key (CMK) used to
// encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric
// CMKs.
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS KMS customer master key (CMK). Amazon Kendra doesn't
	// support asymmetric CMKs.
	KmsKeyId *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information required to connect to a ServiceNow data
// source.
type ServiceNowConfiguration struct {
	_ struct{} `type:"structure"`

	// The ServiceNow instance that the data source connects to. The host endpoint
	// should look like the following: {instance}.service-now.com.
	//
	// HostUrl is a required field
	HostUrl *string `min:"1" type:"string" required:"true"`

	// Provides configuration information for crawling knowledge articles in the
	// ServiceNow site.
	KnowledgeArticleConfiguration *ServiceNowKnowledgeArticleConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Secret Manager secret that contains
	// the user name and password required to connect to the ServiceNow instance.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// Provides configuration information for crawling service catalogs in the ServiceNow
	// site.
	ServiceCatalogConfiguration *ServiceNowServiceCatalogConfiguration `type:"structure"`

	// The identifier of the release that the ServiceNow host is running. If the
	// host is not running the LONDON release, use OTHERS.
	//
	// ServiceNowBuildVersion is a required field
	ServiceNowBuildVersion ServiceNowBuildVersionType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ServiceNowConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServiceNowConfiguration"}

	if s.HostUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostUrl"))
	}
	if s.HostUrl != nil && len(*s.HostUrl) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HostUrl", 1))
	}

	if s.SecretArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretArn", 1))
	}
	if len(s.ServiceNowBuildVersion) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ServiceNowBuildVersion"))
	}
	if s.KnowledgeArticleConfiguration != nil {
		if err := s.KnowledgeArticleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KnowledgeArticleConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.ServiceCatalogConfiguration != nil {
		if err := s.ServiceCatalogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServiceCatalogConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for crawling knowledge articles in the
// ServiceNow site.
type ServiceNowKnowledgeArticleConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether Amazon Kendra should index attachments to knowledge articles.
	CrawlAttachments *bool `type:"boolean"`

	// The name of the ServiceNow field that is mapped to the index document contents
	// field in the Amazon Kendra index.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the ServiceNow field that is mapped to the index document title
	// field.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// List of regular expressions applied to knowledge articles. Items that don't
	// match the inclusion pattern are not indexed. The regex is applied to the
	// field specified in the PatternTargetField
	ExcludeAttachmentFilePatterns []string `type:"list"`

	// Mapping between ServiceNow fields and Amazon Kendra index fields. You must
	// create the index field before you map the field.
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// List of regular expressions applied to knowledge articles. Items that don't
	// match the inclusion pattern are not indexed. The regex is applied to the
	// field specified in the PatternTargetField.
	IncludeAttachmentFilePatterns []string `type:"list"`
}

// String returns the string representation
func (s ServiceNowKnowledgeArticleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowKnowledgeArticleConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServiceNowKnowledgeArticleConfiguration"}

	if s.DocumentDataFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for crawling service catalog items in
// the ServiceNow site
type ServiceNowServiceCatalogConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether Amazon Kendra should crawl attachments to the service catalog
	// items.
	CrawlAttachments *bool `type:"boolean"`

	// The name of the ServiceNow field that is mapped to the index document contents
	// field in the Amazon Kendra index.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the ServiceNow field that is mapped to the index document title
	// field.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// Determines the types of file attachments that are excluded from the index.
	ExcludeAttachmentFilePatterns []string `type:"list"`

	// Mapping between ServiceNow fields and Amazon Kendra index fields. You must
	// create the index field before you map the field.
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// Determines the types of file attachments that are included in the index.
	IncludeAttachmentFilePatterns []string `type:"list"`
}

// String returns the string representation
func (s ServiceNowServiceCatalogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowServiceCatalogConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServiceNowServiceCatalogConfiguration"}

	if s.DocumentDataFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for connecting to a Microsoft SharePoint
// data source.
type SharePointConfiguration struct {
	_ struct{} `type:"structure"`

	// TRUE to include attachments to documents stored in your Microsoft SharePoint
	// site in the index; otherwise, FALSE.
	CrawlAttachments *bool `type:"boolean"`

	// The Microsoft SharePoint attribute field that contains the title of the document.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// A list of regulary expression patterns. Documents that match the patterns
	// are excluded from the index. Documents that don't match the patterns are
	// included in the index. If a document matches both an exclusion pattern and
	// an inclusion pattern, the document is not included in the index.
	//
	// The regex is applied to the display URL of the SharePoint document.
	ExclusionPatterns []string `type:"list"`

	// A list of DataSourceToIndexFieldMapping objects that map Microsoft SharePoint
	// attributes to custom fields in the Amazon Kendra index. You must first create
	// the index fields using the operation before you map SharePoint attributes.
	// For more information, see Mapping Data Source Fields (https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html).
	FieldMappings []DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// A list of regular expression patterns. Documents that match the patterns
	// are included in the index. Documents that don't match the patterns are excluded
	// from the index. If a document matches both an inclusion pattern and an exclusion
	// pattern, the document is not included in the index.
	//
	// The regex is applied to the display URL of the SharePoint document.
	InclusionPatterns []string `type:"list"`

	// The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager.
	// The credentials should be a user/password pair. For more information, see
	// Using a Microsoft SharePoint Data Source (https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html).
	// For more information about AWS Secrets Manager, see What Is AWS Secrets Manager
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	// in the AWS Secrets Manager user guide.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The version of Microsoft SharePoint that you are using as a data source.
	//
	// SharePointVersion is a required field
	SharePointVersion SharePointVersion `type:"string" required:"true" enum:"true"`

	// The URLs of the Microsoft SharePoint site that contains the documents that
	// should be indexed.
	//
	// Urls is a required field
	Urls []string `min:"1" type:"list" required:"true"`

	// Set to TRUE to use the Microsoft SharePoint change log to determine the documents
	// that need to be updated in the index. Depending on the size of the SharePoint
	// change log, it may take longer for Amazon Kendra to use the change log than
	// it takes it to determine the changed documents using the Amazon Kendra document
	// crawler.
	UseChangeLog *bool `type:"boolean"`

	// Provides information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s SharePointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SharePointConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SharePointConfiguration"}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FieldMappings", 1))
	}

	if s.SecretArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretArn", 1))
	}
	if len(s.SharePointVersion) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SharePointVersion"))
	}

	if s.Urls == nil {
		invalidParams.Add(aws.NewErrParamRequired("Urls"))
	}
	if s.Urls != nil && len(s.Urls) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Urls", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of key/value pairs that identify an index, FAQ, or data source. Tag
// keys and values can consist of Unicode letters, digits, white space, and
// any of the following symbols: _ . : / = + - @.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the tag. Keys are not case sensitive and must be unique for the
	// index, FAQ, or data source.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value associated with the tag. The value may be an empty string but it
	// can't be null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about text documents indexed in an index.
type TextDocumentStatistics struct {
	_ struct{} `type:"structure"`

	// The total size, in bytes, of the indexed documents.
	//
	// IndexedTextBytes is a required field
	IndexedTextBytes *int64 `type:"long" required:"true"`

	// The number of text documents indexed.
	//
	// IndexedTextDocumentsCount is a required field
	IndexedTextDocumentsCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s TextDocumentStatistics) String() string {
	return awsutil.Prettify(s)
}

// Provides text and information about where to highlight the text.
type TextWithHighlights struct {
	_ struct{} `type:"structure"`

	// The beginning and end of the text that should be highlighted.
	Highlights []Highlight `type:"list"`

	// The text to display to the user.
	Text *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TextWithHighlights) String() string {
	return awsutil.Prettify(s)
}

// Provides a range of time.
type TimeRange struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime of the end of the time range.
	EndTime *time.Time `type:"timestamp"`

	// The UNIX datetime of the beginning of the time range.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TimeRange) String() string {
	return awsutil.Prettify(s)
}
