// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Identifies the run configuration (start parameters) of a Kinesis Data Analytics
	// application.
	//
	// RunConfiguration is a required field
	RunConfiguration *RunConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartApplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartApplicationInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.RunConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("RunConfiguration"))
	}
	if s.RunConfiguration != nil {
		if err := s.RunConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RunConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartApplication = "StartApplication"

// StartApplicationRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
// Starts the specified Amazon Kinesis Data Analytics application. After creating
// an application, you must exclusively call this operation to start your application.
//
//    // Example sending a request using StartApplicationRequest.
//    req := client.StartApplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StartApplication
func (c *Client) StartApplicationRequest(input *StartApplicationInput) StartApplicationRequest {
	op := &aws.Operation{
		Name:       opStartApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartApplicationInput{}
	}

	req := c.newRequest(op, input, &StartApplicationOutput{})

	return StartApplicationRequest{Request: req, Input: input, Copy: c.StartApplicationRequest}
}

// StartApplicationRequest is the request type for the
// StartApplication API operation.
type StartApplicationRequest struct {
	*aws.Request
	Input *StartApplicationInput
	Copy  func(*StartApplicationInput) StartApplicationRequest
}

// Send marshals and sends the StartApplication API request.
func (r StartApplicationRequest) Send(ctx context.Context) (*StartApplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartApplicationResponse{
		StartApplicationOutput: r.Request.Data.(*StartApplicationOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartApplicationResponse is the response type for the
// StartApplication API operation.
type StartApplicationResponse struct {
	*StartApplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartApplication request.
func (r *StartApplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
