// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Describes application configuration updates.
	ApplicationConfigurationUpdate *ApplicationConfigurationUpdate `type:"structure"`

	// The name of the application to update.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Describes application Amazon CloudWatch logging option updates. You can only
	// update existing CloudWatch logging options with this action. To add a new
	// CloudWatch logging option, use AddApplicationCloudWatchLoggingOption.
	CloudWatchLoggingOptionUpdates []CloudWatchLoggingOptionUpdate `type:"list"`

	// The current application version ID. You can retrieve the application version
	// ID using DescribeApplication.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// Describes updates to the application's starting parameters.
	RunConfigurationUpdate *RunConfigurationUpdate `type:"structure"`

	// Describes updates to the service execution role.
	ServiceExecutionRoleUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateApplicationInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.ServiceExecutionRoleUpdate != nil && len(*s.ServiceExecutionRoleUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceExecutionRoleUpdate", 1))
	}
	if s.ApplicationConfigurationUpdate != nil {
		if err := s.ApplicationConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ApplicationConfigurationUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.CloudWatchLoggingOptionUpdates != nil {
		for i, v := range s.CloudWatchLoggingOptionUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CloudWatchLoggingOptionUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.RunConfigurationUpdate != nil {
		if err := s.RunConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("RunConfigurationUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Describes application updates.
	//
	// ApplicationDetail is a required field
	ApplicationDetail *ApplicationDetail `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
// Updates an existing Amazon Kinesis Data Analytics application. Using this
// operation, you can update application code, input configuration, and output
// configuration.
//
// Kinesis Data Analytics updates the ApplicationVersionId each time you update
// your application.
//
//    // Example sending a request using UpdateApplicationRequest.
//    req := client.UpdateApplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplication
func (c *Client) UpdateApplicationRequest(input *UpdateApplicationInput) UpdateApplicationRequest {
	op := &aws.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	req := c.newRequest(op, input, &UpdateApplicationOutput{})

	return UpdateApplicationRequest{Request: req, Input: input, Copy: c.UpdateApplicationRequest}
}

// UpdateApplicationRequest is the request type for the
// UpdateApplication API operation.
type UpdateApplicationRequest struct {
	*aws.Request
	Input *UpdateApplicationInput
	Copy  func(*UpdateApplicationInput) UpdateApplicationRequest
}

// Send marshals and sends the UpdateApplication API request.
func (r UpdateApplicationRequest) Send(ctx context.Context) (*UpdateApplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateApplicationResponse{
		UpdateApplicationOutput: r.Request.Data.(*UpdateApplicationOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateApplicationResponse is the response type for the
// UpdateApplication API operation.
type UpdateApplicationResponse struct {
	*UpdateApplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateApplication request.
func (r *UpdateApplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
