// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisvideoarchivedmedia

import (
	"context"
	"io"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetClipInput struct {
	_ struct{} `type:"structure"`

	// The time range of the requested clip and the source of the timestamps.
	//
	// ClipFragmentSelector is a required field
	ClipFragmentSelector *ClipFragmentSelector `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the stream for which to retrieve the media
	// clip.
	//
	// You must specify either the StreamName or the StreamARN.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream for which to retrieve the media clip.
	//
	// You must specify either the StreamName or the StreamARN.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetClipInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetClipInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetClipInput"}

	if s.ClipFragmentSelector == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClipFragmentSelector"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamName", 1))
	}
	if s.ClipFragmentSelector != nil {
		if err := s.ClipFragmentSelector.Validate(); err != nil {
			invalidParams.AddNested("ClipFragmentSelector", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetClipInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ClipFragmentSelector != nil {
		v := s.ClipFragmentSelector

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ClipFragmentSelector", v, metadata)
	}
	if s.StreamARN != nil {
		v := *s.StreamARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamName != nil {
		v := *s.StreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetClipOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The content type of the media in the requested clip.
	ContentType *string `location:"header" locationName:"Content-Type" min:"1" type:"string"`

	// Traditional MP4 file that contains the media clip from the specified video
	// stream. The output will contain the first 100 MB or the first 200 fragments
	// from the specified start timestamp. For more information, see Kinesis Video
	// Streams Limits (Kinesis Video Streams Limits).
	Payload io.ReadCloser `type:"blob"`
}

// String returns the string representation
func (s GetClipOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetClipOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// Skipping Payload Output type's body not valid.
	return nil
}

const opGetClip = "GetClip"

// GetClipRequest returns a request value for making API operation for
// Amazon Kinesis Video Streams Archived Media.
//
// Downloads an MP4 file (clip) containing the archived, on-demand media from
// the specified video stream over the specified time range.
//
// Both the StreamName and the StreamARN parameters are optional, but you must
// specify either the StreamName or the StreamARN when invoking this API operation.
//
// As a prerequsite to using GetCLip API, you must obtain an endpoint using
// GetDataEndpoint, specifying GET_CLIP for the APIName parameter.
//
// An Amazon Kinesis video stream has the following requirements for providing
// data through MP4:
//
//    * The media must contain h.264 or h.265 encoded video and, optionally,
//    AAC or G.711 encoded audio. Specifically, the codec ID of track 1 should
//    be V_MPEG/ISO/AVC (for h.264) or V_MPEGH/ISO/HEVC (for H.265). Optionally,
//    the codec ID of track 2 should be A_AAC (for AAC) or A_MS/ACM (for G.711).
//
//    * Data retention must be greater than 0.
//
//    * The video track of each fragment must contain codec private data in
//    the Advanced Video Coding (AVC) for H.264 format and HEVC for H.265 format.
//    For more information, see MPEG-4 specification ISO/IEC 14496-15 (https://www.iso.org/standard/55980.html).
//    For information about adapting stream data to a given format, see NAL
//    Adaptation Flags (http://docs.aws.amazon.com/kinesisvideostreams/latest/dg/producer-reference-nal.html).
//
//    * The audio track (if present) of each fragment must contain codec private
//    data in the AAC format (AAC specification ISO/IEC 13818-7 (https://www.iso.org/standard/43345.html))
//    or the MS Wave format (http://www-mmsp.ece.mcgill.ca/Documents/AudioFormats/WAVE/WAVE.html).
//
// You can monitor the amount of outgoing data by monitoring the GetClip.OutgoingBytes
// Amazon CloudWatch metric. For information about using CloudWatch to monitor
// Kinesis Video Streams, see Monitoring Kinesis Video Streams (http://docs.aws.amazon.com/kinesisvideostreams/latest/dg/monitoring.html).
// For pricing information, see Amazon Kinesis Video Streams Pricing (https://aws.amazon.com/kinesis/video-streams/pricing/)
// and AWS Pricing (https://aws.amazon.com/pricing/). Charges for outgoing AWS
// data apply.
//
//    // Example sending a request using GetClipRequest.
//    req := client.GetClipRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-archived-media-2017-09-30/GetClip
func (c *Client) GetClipRequest(input *GetClipInput) GetClipRequest {
	op := &aws.Operation{
		Name:       opGetClip,
		HTTPMethod: "POST",
		HTTPPath:   "/getClip",
	}

	if input == nil {
		input = &GetClipInput{}
	}

	req := c.newRequest(op, input, &GetClipOutput{})

	return GetClipRequest{Request: req, Input: input, Copy: c.GetClipRequest}
}

// GetClipRequest is the request type for the
// GetClip API operation.
type GetClipRequest struct {
	*aws.Request
	Input *GetClipInput
	Copy  func(*GetClipInput) GetClipRequest
}

// Send marshals and sends the GetClip API request.
func (r GetClipRequest) Send(ctx context.Context) (*GetClipResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetClipResponse{
		GetClipOutput: r.Request.Data.(*GetClipOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetClipResponse is the response type for the
// GetClip API operation.
type GetClipResponse struct {
	*GetClipOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetClip request.
func (r *GetClipResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
