// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisconnectCustomKeyStoreInput struct {
	_ struct{} `type:"structure"`

	// Enter the ID of the custom key store you want to disconnect. To find the
	// ID of a custom key store, use the DescribeCustomKeyStores operation.
	//
	// CustomKeyStoreId is a required field
	CustomKeyStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisconnectCustomKeyStoreInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectCustomKeyStoreInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisconnectCustomKeyStoreInput"}

	if s.CustomKeyStoreId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CustomKeyStoreId"))
	}
	if s.CustomKeyStoreId != nil && len(*s.CustomKeyStoreId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CustomKeyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisconnectCustomKeyStoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisconnectCustomKeyStoreOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisconnectCustomKeyStore = "DisconnectCustomKeyStore"

// DisconnectCustomKeyStoreRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Disconnects the custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// from its associated AWS CloudHSM cluster. While a custom key store is disconnected,
// you can manage the custom key store and its customer master keys (CMKs),
// but you cannot create or use CMKs in the custom key store. You can reconnect
// the custom key store at any time.
//
// While a custom key store is disconnected, all attempts to create customer
// master keys (CMKs) in the custom key store or to use existing CMKs in cryptographic
// operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
// will fail. This action can prevent users from storing and accessing sensitive
// data.
//
// To find the connection state of a custom key store, use the DescribeCustomKeyStores
// operation. To reconnect a custom key store, use the ConnectCustomKeyStore
// operation.
//
// If the operation succeeds, it returns a JSON object with no properties.
//
// This operation is part of the Custom Key Store feature (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// feature in AWS KMS, which combines the convenience and extensive integration
// of AWS KMS with the isolation and control of a single-tenant key store.
//
//    // Example sending a request using DisconnectCustomKeyStoreRequest.
//    req := client.DisconnectCustomKeyStoreRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisconnectCustomKeyStore
func (c *Client) DisconnectCustomKeyStoreRequest(input *DisconnectCustomKeyStoreInput) DisconnectCustomKeyStoreRequest {
	op := &aws.Operation{
		Name:       opDisconnectCustomKeyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisconnectCustomKeyStoreInput{}
	}

	req := c.newRequest(op, input, &DisconnectCustomKeyStoreOutput{})

	return DisconnectCustomKeyStoreRequest{Request: req, Input: input, Copy: c.DisconnectCustomKeyStoreRequest}
}

// DisconnectCustomKeyStoreRequest is the request type for the
// DisconnectCustomKeyStore API operation.
type DisconnectCustomKeyStoreRequest struct {
	*aws.Request
	Input *DisconnectCustomKeyStoreInput
	Copy  func(*DisconnectCustomKeyStoreInput) DisconnectCustomKeyStoreRequest
}

// Send marshals and sends the DisconnectCustomKeyStore API request.
func (r DisconnectCustomKeyStoreRequest) Send(ctx context.Context) (*DisconnectCustomKeyStoreResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisconnectCustomKeyStoreResponse{
		DisconnectCustomKeyStoreOutput: r.Request.Data.(*DisconnectCustomKeyStoreOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisconnectCustomKeyStoreResponse is the response type for the
// DisconnectCustomKeyStore API operation.
type DisconnectCustomKeyStoreResponse struct {
	*DisconnectCustomKeyStoreOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisconnectCustomKeyStore request.
func (r *DisconnectCustomKeyStoreResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
