// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type EncryptInput struct {
	_ struct{} `type:"structure"`

	// Specifies the encryption algorithm that AWS KMS will use to encrypt the plaintext
	// message. The algorithm must be compatible with the CMK that you specify.
	//
	// This parameter is required only for asymmetric CMKs. The default value, SYMMETRIC_DEFAULT,
	// is the algorithm used for symmetric CMKs. If you are using an asymmetric
	// CMK, we recommend RSAES_OAEP_SHA_256.
	EncryptionAlgorithm EncryptionAlgorithmSpec `type:"string" enum:"true"`

	// Specifies the encryption context that will be used to encrypt the data. An
	// encryption context is valid only for cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// with a symmetric CMK. The standard asymmetric encryption algorithms that
	// AWS KMS uses do not support an encryption context.
	//
	// An encryption context is a collection of non-secret key-value pairs that
	// represents additional authenticated data. When you use an encryption context
	// to encrypt data, you must specify the same (an exact case-sensitive match)
	// encryption context to decrypt the data. An encryption context is optional
	// when encrypting with a symmetric CMK, but it is highly recommended.
	//
	// For more information, see Encryption Context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
	// in the AWS Key Management Service Developer Guide.
	EncryptionContext map[string]string `type:"map"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []string `type:"list"`

	// A unique identifier for the customer master key (CMK).
	//
	// To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name,
	// or alias ARN. When using an alias name, prefix it with "alias/". To specify
	// a CMK in a different AWS account, you must use the key ARN or alias ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
	// get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Data to be encrypted.
	//
	// Plaintext is automatically base64 encoded/decoded by the SDK.
	//
	// Plaintext is a required field
	Plaintext []byte `min:"1" type:"blob" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s EncryptInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EncryptInput"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}

	if s.Plaintext == nil {
		invalidParams.Add(aws.NewErrParamRequired("Plaintext"))
	}
	if s.Plaintext != nil && len(s.Plaintext) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Plaintext", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EncryptOutput struct {
	_ struct{} `type:"structure"`

	// The encrypted plaintext. When you use the HTTP API or the AWS CLI, the value
	// is Base64-encoded. Otherwise, it is not Base64-encoded.
	//
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// The encryption algorithm that was used to encrypt the plaintext.
	EncryptionAlgorithm EncryptionAlgorithmSpec `type:"string" enum:"true"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the CMK that was used to encrypt the plaintext.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EncryptOutput) String() string {
	return awsutil.Prettify(s)
}

const opEncrypt = "Encrypt"

// EncryptRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Encrypts plaintext into ciphertext by using a customer master key (CMK).
// The Encrypt operation has two primary use cases:
//
//    * You can encrypt small amounts of arbitrary data, such as a personal
//    identifier or database password, or other sensitive information.
//
//    * You can use the Encrypt operation to move encrypted data from one AWS
//    Region to another. For example, in Region A, generate a data key and use
//    the plaintext key to encrypt your data. Then, in Region A, use the Encrypt
//    operation to encrypt the plaintext data key under a CMK in Region B. Now,
//    you can move the encrypted data and the encrypted data key to Region B.
//    When necessary, you can decrypt the encrypted data key and the encrypted
//    data entirely within in Region B.
//
// You don't need to use the Encrypt operation to encrypt a data key. The GenerateDataKey
// and GenerateDataKeyPair operations return a plaintext data key and an encrypted
// copy of that data key.
//
// When you encrypt data, you must specify a symmetric or asymmetric CMK to
// use in the encryption operation. The CMK must have a KeyUsage value of ENCRYPT_DECRYPT.
// To find the KeyUsage of a CMK, use the DescribeKey operation.
//
// If you use a symmetric CMK, you can use an encryption context to add additional
// security to your encryption operation. If you specify an EncryptionContext
// when encrypting data, you must specify the same encryption context (a case-sensitive
// exact match) when decrypting the data. Otherwise, the request to decrypt
// fails with an InvalidCiphertextException. For more information, see Encryption
// Context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
// in the AWS Key Management Service Developer Guide.
//
// If you specify an asymmetric CMK, you must also specify the encryption algorithm.
// The algorithm must be compatible with the CMK type.
//
// When you use an asymmetric CMK to encrypt or reencrypt data, be sure to record
// the CMK and encryption algorithm that you choose. You will be required to
// provide the same CMK and encryption algorithm when you decrypt the data.
// If the CMK and algorithm do not match the values used to encrypt the data,
// the decrypt operation fails.
//
// You are not required to supply the CMK ID and encryption algorithm when you
// decrypt with symmetric CMKs because AWS KMS stores this information in the
// ciphertext blob. AWS KMS cannot store metadata in ciphertext generated with
// asymmetric keys. The standard format for asymmetric key ciphertext does not
// include configurable fields.
//
// The maximum size of the data that you can encrypt varies with the type of
// CMK and the encryption algorithm that you choose.
//
//    * Symmetric CMKs SYMMETRIC_DEFAULT: 4096 bytes
//
//    * RSA_2048 RSAES_OAEP_SHA_1: 214 bytes RSAES_OAEP_SHA_256: 190 bytes
//
//    * RSA_3072 RSAES_OAEP_SHA_1: 342 bytes RSAES_OAEP_SHA_256: 318 bytes
//
//    * RSA_4096 RSAES_OAEP_SHA_1: 470 bytes RSAES_OAEP_SHA_256: 446 bytes
//
// The CMK that you use for this operation must be in a compatible key state.
// For details, see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
// To perform this operation on a CMK in a different AWS account, specify the
// key ARN or alias ARN in the value of the KeyId parameter.
//
//    // Example sending a request using EncryptRequest.
//    req := client.EncryptRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Encrypt
func (c *Client) EncryptRequest(input *EncryptInput) EncryptRequest {
	op := &aws.Operation{
		Name:       opEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EncryptInput{}
	}

	req := c.newRequest(op, input, &EncryptOutput{})

	return EncryptRequest{Request: req, Input: input, Copy: c.EncryptRequest}
}

// EncryptRequest is the request type for the
// Encrypt API operation.
type EncryptRequest struct {
	*aws.Request
	Input *EncryptInput
	Copy  func(*EncryptInput) EncryptRequest
}

// Send marshals and sends the Encrypt API request.
func (r EncryptRequest) Send(ctx context.Context) (*EncryptResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EncryptResponse{
		EncryptOutput: r.Request.Data.(*EncryptOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EncryptResponse is the response type for the
// Encrypt API operation.
type EncryptResponse struct {
	*EncryptOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// Encrypt request.
func (r *EncryptResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
