// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type VerifyInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []string `type:"list"`

	// Identifies the asymmetric CMK that will be used to verify the signature.
	// This must be the same CMK that was used to generate the signature. If you
	// specify a different CMK, the signature verification fails.
	//
	// To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name,
	// or alias ARN. When using an alias name, prefix it with "alias/". To specify
	// a CMK in a different AWS account, you must use the key ARN or alias ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
	// get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Specifies the message that was signed. You can submit a raw message of up
	// to 4096 bytes, or a hash digest of the message. If you submit a digest, use
	// the MessageType parameter with a value of DIGEST.
	//
	// If the message specified here is different from the message that was signed,
	// the signature verification fails. A message and its hash digest are considered
	// to be the same message.
	//
	// Message is automatically base64 encoded/decoded by the SDK.
	//
	// Message is a required field
	Message []byte `min:"1" type:"blob" required:"true" sensitive:"true"`

	// Tells AWS KMS whether the value of the Message parameter is a message or
	// message digest. The default value, RAW, indicates a message. To indicate
	// a message digest, enter DIGEST.
	//
	// Use the DIGEST value only when the value of the Message parameter is a message
	// digest. If you use the DIGEST value with a raw message, the security of the
	// verification operation can be compromised.
	MessageType MessageType `type:"string" enum:"true"`

	// The signature that the Sign operation generated.
	//
	// Signature is automatically base64 encoded/decoded by the SDK.
	//
	// Signature is a required field
	Signature []byte `min:"1" type:"blob" required:"true"`

	// The signing algorithm that was used to sign the message. If you submit a
	// different algorithm, the signature verification fails.
	//
	// SigningAlgorithm is a required field
	SigningAlgorithm SigningAlgorithmSpec `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s VerifyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VerifyInput"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}

	if s.Message == nil {
		invalidParams.Add(aws.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(s.Message) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Message", 1))
	}

	if s.Signature == nil {
		invalidParams.Add(aws.NewErrParamRequired("Signature"))
	}
	if s.Signature != nil && len(s.Signature) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Signature", 1))
	}
	if len(s.SigningAlgorithm) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SigningAlgorithm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type VerifyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the asymmetric CMK that was used to verify the signature.
	KeyId *string `min:"1" type:"string"`

	// A Boolean value that indicates whether the signature was verified. A value
	// of True indicates that the Signature was produced by signing the Message
	// with the specified KeyID and SigningAlgorithm. If the signature is not verified,
	// the Verify operation fails with a KMSInvalidSignatureException exception.
	SignatureValid *bool `type:"boolean"`

	// The signing algorithm that was used to verify the signature.
	SigningAlgorithm SigningAlgorithmSpec `type:"string" enum:"true"`
}

// String returns the string representation
func (s VerifyOutput) String() string {
	return awsutil.Prettify(s)
}

const opVerify = "Verify"

// VerifyRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Verifies a digital signature that was generated by the Sign operation.
//
// Verification confirms that an authorized user signed the message with the
// specified CMK and signing algorithm, and the message hasn't changed since
// it was signed. If the signature is verified, the value of the SignatureValid
// field in the response is True. If the signature verification fails, the Verify
// operation fails with an KMSInvalidSignatureException exception.
//
// A digital signature is generated by using the private key in an asymmetric
// CMK. The signature is verified by using the public key in the same asymmetric
// CMK. For information about symmetric and asymmetric CMKs, see Using Symmetric
// and Asymmetric CMKs (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
// in the AWS Key Management Service Developer Guide.
//
// To verify a digital signature, you can use the Verify operation. Specify
// the same asymmetric CMK, message, and signing algorithm that were used to
// produce the signature.
//
// You can also verify the digital signature by using the public key of the
// CMK outside of AWS KMS. Use the GetPublicKey operation to download the public
// key in the asymmetric CMK and then use the public key to verify the signature
// outside of AWS KMS. The advantage of using the Verify operation is that it
// is performed within AWS KMS. As a result, it's easy to call, the operation
// is performed within the FIPS boundary, it is logged in AWS CloudTrail, and
// you can use key policy and IAM policy to determine who is authorized to use
// the CMK to verify signatures.
//
// The CMK that you use for this operation must be in a compatible key state.
// For details, see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
//    // Example sending a request using VerifyRequest.
//    req := client.VerifyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Verify
func (c *Client) VerifyRequest(input *VerifyInput) VerifyRequest {
	op := &aws.Operation{
		Name:       opVerify,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyInput{}
	}

	req := c.newRequest(op, input, &VerifyOutput{})

	return VerifyRequest{Request: req, Input: input, Copy: c.VerifyRequest}
}

// VerifyRequest is the request type for the
// Verify API operation.
type VerifyRequest struct {
	*aws.Request
	Input *VerifyInput
	Copy  func(*VerifyInput) VerifyRequest
}

// Send marshals and sends the Verify API request.
func (r VerifyRequest) Send(ctx context.Context) (*VerifyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &VerifyResponse{
		VerifyOutput: r.Request.Data.(*VerifyOutput),
		response:     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// VerifyResponse is the response type for the
// Verify API operation.
type VerifyResponse struct {
	*VerifyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// Verify request.
func (r *VerifyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
