// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListProvisionedConcurrencyConfigsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Specify a number to limit the number of configurations returned.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListProvisionedConcurrencyConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProvisionedConcurrencyConfigsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListProvisionedConcurrencyConfigsInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProvisionedConcurrencyConfigsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	return nil
}

type ListProvisionedConcurrencyConfigsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that's included if more results are available.
	NextMarker *string `type:"string"`

	// A list of provisioned concurrency configurations.
	ProvisionedConcurrencyConfigs []ProvisionedConcurrencyConfigListItem `type:"list"`
}

// String returns the string representation
func (s ListProvisionedConcurrencyConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProvisionedConcurrencyConfigsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProvisionedConcurrencyConfigs != nil {
		v := s.ProvisionedConcurrencyConfigs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProvisionedConcurrencyConfigs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListProvisionedConcurrencyConfigs = "ListProvisionedConcurrencyConfigs"

// ListProvisionedConcurrencyConfigsRequest returns a request value for making API operation for
// AWS Lambda.
//
// Retrieves a list of provisioned concurrency configurations for a function.
//
//    // Example sending a request using ListProvisionedConcurrencyConfigsRequest.
//    req := client.ListProvisionedConcurrencyConfigsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs
func (c *Client) ListProvisionedConcurrencyConfigsRequest(input *ListProvisionedConcurrencyConfigsInput) ListProvisionedConcurrencyConfigsRequest {
	op := &aws.Operation{
		Name:       opListProvisionedConcurrencyConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-09-30/functions/{FunctionName}/provisioned-concurrency?List=ALL",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProvisionedConcurrencyConfigsInput{}
	}

	req := c.newRequest(op, input, &ListProvisionedConcurrencyConfigsOutput{})

	return ListProvisionedConcurrencyConfigsRequest{Request: req, Input: input, Copy: c.ListProvisionedConcurrencyConfigsRequest}
}

// ListProvisionedConcurrencyConfigsRequest is the request type for the
// ListProvisionedConcurrencyConfigs API operation.
type ListProvisionedConcurrencyConfigsRequest struct {
	*aws.Request
	Input *ListProvisionedConcurrencyConfigsInput
	Copy  func(*ListProvisionedConcurrencyConfigsInput) ListProvisionedConcurrencyConfigsRequest
}

// Send marshals and sends the ListProvisionedConcurrencyConfigs API request.
func (r ListProvisionedConcurrencyConfigsRequest) Send(ctx context.Context) (*ListProvisionedConcurrencyConfigsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListProvisionedConcurrencyConfigsResponse{
		ListProvisionedConcurrencyConfigsOutput: r.Request.Data.(*ListProvisionedConcurrencyConfigsOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListProvisionedConcurrencyConfigsRequestPaginator returns a paginator for ListProvisionedConcurrencyConfigs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListProvisionedConcurrencyConfigsRequest(input)
//   p := lambda.NewListProvisionedConcurrencyConfigsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListProvisionedConcurrencyConfigsPaginator(req ListProvisionedConcurrencyConfigsRequest) ListProvisionedConcurrencyConfigsPaginator {
	return ListProvisionedConcurrencyConfigsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListProvisionedConcurrencyConfigsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListProvisionedConcurrencyConfigsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListProvisionedConcurrencyConfigsPaginator struct {
	aws.Pager
}

func (p *ListProvisionedConcurrencyConfigsPaginator) CurrentPage() *ListProvisionedConcurrencyConfigsOutput {
	return p.Pager.CurrentPage().(*ListProvisionedConcurrencyConfigsOutput)
}

// ListProvisionedConcurrencyConfigsResponse is the response type for the
// ListProvisionedConcurrencyConfigs API operation.
type ListProvisionedConcurrencyConfigsResponse struct {
	*ListProvisionedConcurrencyConfigsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListProvisionedConcurrencyConfigs request.
func (r *ListProvisionedConcurrencyConfigsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
