// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	//
	//    * Amazon Kinesis - Default 100. Max 10,000.
	//
	//    * Amazon DynamoDB Streams - Default 100. Max 1,000.
	//
	//    * Amazon Simple Queue Service - Default 10. Max 10.
	BatchSize *int64 `min:"1" type:"integer"`

	// (Streams) If the function returns an error, split the batch in two and retry.
	BisectBatchOnFunctionError *bool `type:"boolean"`

	// (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded
	// records.
	DestinationConfig *DestinationConfig `type:"structure"`

	// Disables the event source mapping to pause polling and invocation.
	Enabled *bool `type:"boolean"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Version or Alias ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it's limited to 64 characters in length.
	FunctionName *string `min:"1" type:"string"`

	// (Streams) The maximum amount of time to gather records before invoking the
	// function, in seconds.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// (Streams) The maximum age of a record that Lambda sends to a function for
	// processing.
	MaximumRecordAgeInSeconds *int64 `min:"60" type:"integer"`

	// (Streams) The maximum number of times to retry when the function returns
	// an error.
	MaximumRetryAttempts *int64 `type:"integer"`

	// (Streams) The number of batches to process from each shard concurrently.
	ParallelizationFactor *int64 `min:"1" type:"integer"`

	// The identifier of the event source mapping.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEventSourceMappingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEventSourceMappingInput"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("BatchSize", 1))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaximumRecordAgeInSeconds != nil && *s.MaximumRecordAgeInSeconds < 60 {
		invalidParams.Add(aws.NewErrParamMinValue("MaximumRecordAgeInSeconds", 60))
	}
	if s.ParallelizationFactor != nil && *s.ParallelizationFactor < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ParallelizationFactor", 1))
	}

	if s.UUID == nil {
		invalidParams.Add(aws.NewErrParamRequired("UUID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEventSourceMappingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BatchSize != nil {
		v := *s.BatchSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchSize", protocol.Int64Value(v), metadata)
	}
	if s.BisectBatchOnFunctionError != nil {
		v := *s.BisectBatchOnFunctionError

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BisectBatchOnFunctionError", protocol.BoolValue(v), metadata)
	}
	if s.DestinationConfig != nil {
		v := s.DestinationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DestinationConfig", v, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaximumBatchingWindowInSeconds != nil {
		v := *s.MaximumBatchingWindowInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaximumBatchingWindowInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.MaximumRecordAgeInSeconds != nil {
		v := *s.MaximumRecordAgeInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaximumRecordAgeInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.MaximumRetryAttempts != nil {
		v := *s.MaximumRetryAttempts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaximumRetryAttempts", protocol.Int64Value(v), metadata)
	}
	if s.ParallelizationFactor != nil {
		v := *s.ParallelizationFactor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParallelizationFactor", protocol.Int64Value(v), metadata)
	}
	if s.UUID != nil {
		v := *s.UUID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "UUID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A mapping between an AWS resource and an AWS Lambda function. See CreateEventSourceMapping
// for details.
type UpdateEventSourceMappingOutput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// (Streams) If the function returns an error, split the batch in two and retry.
	BisectBatchOnFunctionError *bool `type:"boolean"`

	// (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded
	// records.
	DestinationConfig *DestinationConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the event source.
	EventSourceArn *string `type:"string"`

	// The ARN of the Lambda function.
	FunctionArn *string `type:"string"`

	// The date that the event source mapping was last updated, or its state changed.
	LastModified *time.Time `type:"timestamp"`

	// The result of the last AWS Lambda invocation of your Lambda function.
	LastProcessingResult *string `type:"string"`

	// (Streams) The maximum amount of time to gather records before invoking the
	// function, in seconds.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// (Streams) The maximum age of a record that Lambda sends to a function for
	// processing.
	MaximumRecordAgeInSeconds *int64 `min:"60" type:"integer"`

	// (Streams) The maximum number of times to retry when the function returns
	// an error.
	MaximumRetryAttempts *int64 `type:"integer"`

	// (Streams) The number of batches to process from each shard concurrently.
	ParallelizationFactor *int64 `min:"1" type:"integer"`

	// The state of the event source mapping. It can be one of the following: Creating,
	// Enabling, Enabled, Disabling, Disabled, Updating, or Deleting.
	State *string `type:"string"`

	// Indicates whether the last change to the event source mapping was made by
	// a user, or by the Lambda service.
	StateTransitionReason *string `type:"string"`

	// The identifier of the event source mapping.
	UUID *string `type:"string"`
}

// String returns the string representation
func (s UpdateEventSourceMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEventSourceMappingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BatchSize != nil {
		v := *s.BatchSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchSize", protocol.Int64Value(v), metadata)
	}
	if s.BisectBatchOnFunctionError != nil {
		v := *s.BisectBatchOnFunctionError

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BisectBatchOnFunctionError", protocol.BoolValue(v), metadata)
	}
	if s.DestinationConfig != nil {
		v := s.DestinationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DestinationConfig", v, metadata)
	}
	if s.EventSourceArn != nil {
		v := *s.EventSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EventSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastProcessingResult != nil {
		v := *s.LastProcessingResult

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastProcessingResult", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaximumBatchingWindowInSeconds != nil {
		v := *s.MaximumBatchingWindowInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaximumBatchingWindowInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.MaximumRecordAgeInSeconds != nil {
		v := *s.MaximumRecordAgeInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaximumRecordAgeInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.MaximumRetryAttempts != nil {
		v := *s.MaximumRetryAttempts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaximumRetryAttempts", protocol.Int64Value(v), metadata)
	}
	if s.ParallelizationFactor != nil {
		v := *s.ParallelizationFactor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParallelizationFactor", protocol.Int64Value(v), metadata)
	}
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StateTransitionReason != nil {
		v := *s.StateTransitionReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateTransitionReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UUID != nil {
		v := *s.UUID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UUID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateEventSourceMapping = "UpdateEventSourceMapping"

// UpdateEventSourceMappingRequest returns a request value for making API operation for
// AWS Lambda.
//
// Updates an event source mapping. You can change the function that AWS Lambda
// invokes, or pause invocation and resume later from the same location.
//
// The following error handling options are only available for stream sources
// (DynamoDB and Kinesis):
//
//    * BisectBatchOnFunctionError - If the function returns an error, split
//    the batch in two and retry.
//
//    * DestinationConfig - Send discarded records to an Amazon SQS queue or
//    Amazon SNS topic.
//
//    * MaximumRecordAgeInSeconds - Discard records older than the specified
//    age.
//
//    * MaximumRetryAttempts - Discard records after the specified number of
//    retries.
//
//    * ParallelizationFactor - Process multiple batches from each shard concurrently.
//
//    // Example sending a request using UpdateEventSourceMappingRequest.
//    req := client.UpdateEventSourceMappingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping
func (c *Client) UpdateEventSourceMappingRequest(input *UpdateEventSourceMappingInput) UpdateEventSourceMappingRequest {
	op := &aws.Operation{
		Name:       opUpdateEventSourceMapping,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &UpdateEventSourceMappingInput{}
	}

	req := c.newRequest(op, input, &UpdateEventSourceMappingOutput{})

	return UpdateEventSourceMappingRequest{Request: req, Input: input, Copy: c.UpdateEventSourceMappingRequest}
}

// UpdateEventSourceMappingRequest is the request type for the
// UpdateEventSourceMapping API operation.
type UpdateEventSourceMappingRequest struct {
	*aws.Request
	Input *UpdateEventSourceMappingInput
	Copy  func(*UpdateEventSourceMappingInput) UpdateEventSourceMappingRequest
}

// Send marshals and sends the UpdateEventSourceMapping API request.
func (r UpdateEventSourceMappingRequest) Send(ctx context.Context) (*UpdateEventSourceMappingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEventSourceMappingResponse{
		UpdateEventSourceMappingOutput: r.Request.Data.(*UpdateEventSourceMappingOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEventSourceMappingResponse is the response type for the
// UpdateEventSourceMapping API operation.
type UpdateEventSourceMappingResponse struct {
	*UpdateEventSourceMappingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEventSourceMapping request.
func (r *UpdateEventSourceMappingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
