// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelbuildingservice_test

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelbuildingservice"
)

var _ aws.Config

// To get information about a bot
//
// This example shows how to get configuration information for a bot.
func ExampleClient_GetBotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := lexmodelbuildingservice.New(cfg)
	input := &lexmodelbuildingservice.GetBotInput{
		Name:           aws.String("DocOrderPizza"),
		VersionOrAlias: aws.String("$LATEST"),
	}

	req := svc.GetBotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lexmodelbuildingservice.ErrCodeNotFoundException:
				fmt.Println(lexmodelbuildingservice.ErrCodeNotFoundException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeLimitExceededException:
				fmt.Println(lexmodelbuildingservice.ErrCodeLimitExceededException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeInternalFailureException:
				fmt.Println(lexmodelbuildingservice.ErrCodeInternalFailureException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeBadRequestException:
				fmt.Println(lexmodelbuildingservice.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a list of bots
//
// This example shows how to get a list of all of the bots in your account.
func ExampleClient_GetBotsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := lexmodelbuildingservice.New(cfg)
	input := &lexmodelbuildingservice.GetBotsInput{
		MaxResults: aws.Int64(5),
		NextToken:  aws.String(""),
	}

	req := svc.GetBotsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lexmodelbuildingservice.ErrCodeNotFoundException:
				fmt.Println(lexmodelbuildingservice.ErrCodeNotFoundException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeLimitExceededException:
				fmt.Println(lexmodelbuildingservice.ErrCodeLimitExceededException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeInternalFailureException:
				fmt.Println(lexmodelbuildingservice.ErrCodeInternalFailureException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeBadRequestException:
				fmt.Println(lexmodelbuildingservice.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a information about an intent
//
// This example shows how to get information about an intent.
func ExampleClient_GetIntentRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := lexmodelbuildingservice.New(cfg)
	input := &lexmodelbuildingservice.GetIntentInput{
		Name:    aws.String("DocOrderPizza"),
		Version: aws.String("$LATEST"),
	}

	req := svc.GetIntentRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lexmodelbuildingservice.ErrCodeNotFoundException:
				fmt.Println(lexmodelbuildingservice.ErrCodeNotFoundException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeLimitExceededException:
				fmt.Println(lexmodelbuildingservice.ErrCodeLimitExceededException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeInternalFailureException:
				fmt.Println(lexmodelbuildingservice.ErrCodeInternalFailureException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeBadRequestException:
				fmt.Println(lexmodelbuildingservice.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a list of intents
//
// This example shows how to get a list of all of the intents in your account.
func ExampleClient_GetIntentsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := lexmodelbuildingservice.New(cfg)
	input := &lexmodelbuildingservice.GetIntentsInput{
		MaxResults: aws.Int64(10),
		NextToken:  aws.String(""),
	}

	req := svc.GetIntentsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lexmodelbuildingservice.ErrCodeNotFoundException:
				fmt.Println(lexmodelbuildingservice.ErrCodeNotFoundException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeLimitExceededException:
				fmt.Println(lexmodelbuildingservice.ErrCodeLimitExceededException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeInternalFailureException:
				fmt.Println(lexmodelbuildingservice.ErrCodeInternalFailureException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeBadRequestException:
				fmt.Println(lexmodelbuildingservice.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a slot type
//
// This example shows how to get information about a slot type.
func ExampleClient_GetSlotTypeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := lexmodelbuildingservice.New(cfg)
	input := &lexmodelbuildingservice.GetSlotTypeInput{
		Name:    aws.String("DocPizzaCrustType"),
		Version: aws.String("$LATEST"),
	}

	req := svc.GetSlotTypeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lexmodelbuildingservice.ErrCodeNotFoundException:
				fmt.Println(lexmodelbuildingservice.ErrCodeNotFoundException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeLimitExceededException:
				fmt.Println(lexmodelbuildingservice.ErrCodeLimitExceededException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeInternalFailureException:
				fmt.Println(lexmodelbuildingservice.ErrCodeInternalFailureException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeBadRequestException:
				fmt.Println(lexmodelbuildingservice.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a list of slot types
//
// This example shows how to get a list of all of the slot types in your account.
func ExampleClient_GetSlotTypesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := lexmodelbuildingservice.New(cfg)
	input := &lexmodelbuildingservice.GetSlotTypesInput{
		MaxResults: aws.Int64(10),
		NextToken:  aws.String(""),
	}

	req := svc.GetSlotTypesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lexmodelbuildingservice.ErrCodeNotFoundException:
				fmt.Println(lexmodelbuildingservice.ErrCodeNotFoundException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeLimitExceededException:
				fmt.Println(lexmodelbuildingservice.ErrCodeLimitExceededException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeInternalFailureException:
				fmt.Println(lexmodelbuildingservice.ErrCodeInternalFailureException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeBadRequestException:
				fmt.Println(lexmodelbuildingservice.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a bot
//
// This example shows how to create a bot for ordering pizzas.
func ExampleClient_PutBotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := lexmodelbuildingservice.New(cfg)
	input := &lexmodelbuildingservice.PutBotInput{
		AbortStatement: &lexmodelbuildingservice.Statement{
			Messages: []lexmodelbuildingservice.Message{
				{
					Content:     aws.String("I don't understand. Can you try again?"),
					ContentType: lexmodelbuildingservice.ContentTypePlainText,
				},
				{
					Content:     aws.String("I'm sorry, I don't understand."),
					ContentType: lexmodelbuildingservice.ContentTypePlainText,
				},
			},
		},
		ChildDirected: aws.Bool(true),
		ClarificationPrompt: &lexmodelbuildingservice.Prompt{
			MaxAttempts: aws.Int64(1),
			Messages: []lexmodelbuildingservice.Message{
				{
					Content:     aws.String("I'm sorry, I didn't hear that. Can you repeat what you just said?"),
					ContentType: lexmodelbuildingservice.ContentTypePlainText,
				},
				{
					Content:     aws.String("Can you say that again?"),
					ContentType: lexmodelbuildingservice.ContentTypePlainText,
				},
			},
		},
		Description:             aws.String("Orders a pizza from a local pizzeria."),
		IdleSessionTTLInSeconds: aws.Int64(300),
		Intents: []lexmodelbuildingservice.Intent{
			{
				IntentName:    aws.String("DocOrderPizza"),
				IntentVersion: aws.String("$LATEST"),
			},
		},
		Locale:          lexmodelbuildingservice.LocaleEnUs,
		Name:            aws.String("DocOrderPizzaBot"),
		ProcessBehavior: lexmodelbuildingservice.ProcessBehaviorSave,
	}

	req := svc.PutBotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lexmodelbuildingservice.ErrCodeConflictException:
				fmt.Println(lexmodelbuildingservice.ErrCodeConflictException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeLimitExceededException:
				fmt.Println(lexmodelbuildingservice.ErrCodeLimitExceededException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeInternalFailureException:
				fmt.Println(lexmodelbuildingservice.ErrCodeInternalFailureException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeBadRequestException:
				fmt.Println(lexmodelbuildingservice.ErrCodeBadRequestException, aerr.Error())
			case lexmodelbuildingservice.ErrCodePreconditionFailedException:
				fmt.Println(lexmodelbuildingservice.ErrCodePreconditionFailedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an intent
//
// This example shows how to create an intent for ordering pizzas.
func ExampleClient_PutIntentRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := lexmodelbuildingservice.New(cfg)
	input := &lexmodelbuildingservice.PutIntentInput{
		ConclusionStatement: &lexmodelbuildingservice.Statement{
			Messages: []lexmodelbuildingservice.Message{
				{
					Content:     aws.String("All right, I ordered  you a {Crust} crust {Type} pizza with {Sauce} sauce."),
					ContentType: lexmodelbuildingservice.ContentTypePlainText,
				},
				{
					Content:     aws.String("OK, your {Crust} crust {Type} pizza with {Sauce} sauce is on the way."),
					ContentType: lexmodelbuildingservice.ContentTypePlainText,
				},
			},
			ResponseCard: aws.String("foo"),
		},
		ConfirmationPrompt: &lexmodelbuildingservice.Prompt{
			MaxAttempts: aws.Int64(1),
			Messages: []lexmodelbuildingservice.Message{
				{
					Content:     aws.String("Should I order  your {Crust} crust {Type} pizza with {Sauce} sauce?"),
					ContentType: lexmodelbuildingservice.ContentTypePlainText,
				},
			},
		},
		Description: aws.String("Order a pizza from a local pizzeria."),
		FulfillmentActivity: &lexmodelbuildingservice.FulfillmentActivity{
			Type: lexmodelbuildingservice.FulfillmentActivityTypeReturnIntent,
		},
		Name: aws.String("DocOrderPizza"),
		RejectionStatement: &lexmodelbuildingservice.Statement{
			Messages: []lexmodelbuildingservice.Message{
				{
					Content:     aws.String("Ok, I'll cancel your order."),
					ContentType: lexmodelbuildingservice.ContentTypePlainText,
				},
				{
					Content:     aws.String("I cancelled your order."),
					ContentType: lexmodelbuildingservice.ContentTypePlainText,
				},
			},
		},
		SampleUtterances: []string{
			"Order me a pizza.",
			"Order me a {Type} pizza.",
			"I want a {Crust} crust {Type} pizza",
			"I want a {Crust} crust {Type} pizza with {Sauce} sauce.",
		},
		Slots: []lexmodelbuildingservice.Slot{
			{
				Description: aws.String("The type of pizza to order."),
				Name:        aws.String("Type"),
				Priority:    aws.Int64(1),
				SampleUtterances: []string{
					"Get me a {Type} pizza.",
					"A {Type} pizza please.",
					"I'd like a {Type} pizza.",
				},
				SlotConstraint:  lexmodelbuildingservice.SlotConstraintRequired,
				SlotType:        aws.String("DocPizzaType"),
				SlotTypeVersion: aws.String("$LATEST"),
				ValueElicitationPrompt: &lexmodelbuildingservice.Prompt{
					MaxAttempts: aws.Int64(1),
					Messages: []lexmodelbuildingservice.Message{
						{
							Content:     aws.String("What type of pizza would you like?"),
							ContentType: lexmodelbuildingservice.ContentTypePlainText,
						},
						{
							Content:     aws.String("Vegie or cheese pizza?"),
							ContentType: lexmodelbuildingservice.ContentTypePlainText,
						},
						{
							Content:     aws.String("I can get you a vegie or a cheese pizza."),
							ContentType: lexmodelbuildingservice.ContentTypePlainText,
						},
					},
				},
			},
			{
				Description: aws.String("The type of pizza crust to order."),
				Name:        aws.String("Crust"),
				Priority:    aws.Int64(2),
				SampleUtterances: []string{
					"Make it a {Crust} crust.",
					"I'd like a {Crust} crust.",
				},
				SlotConstraint:  lexmodelbuildingservice.SlotConstraintRequired,
				SlotType:        aws.String("DocPizzaCrustType"),
				SlotTypeVersion: aws.String("$LATEST"),
				ValueElicitationPrompt: &lexmodelbuildingservice.Prompt{
					MaxAttempts: aws.Int64(1),
					Messages: []lexmodelbuildingservice.Message{
						{
							Content:     aws.String("What type of crust would you like?"),
							ContentType: lexmodelbuildingservice.ContentTypePlainText,
						},
						{
							Content:     aws.String("Thick or thin crust?"),
							ContentType: lexmodelbuildingservice.ContentTypePlainText,
						},
					},
				},
			},
			{
				Description: aws.String("The type of sauce to use on the pizza."),
				Name:        aws.String("Sauce"),
				Priority:    aws.Int64(3),
				SampleUtterances: []string{
					"Make it {Sauce} sauce.",
					"I'd like {Sauce} sauce.",
				},
				SlotConstraint:  lexmodelbuildingservice.SlotConstraintRequired,
				SlotType:        aws.String("DocPizzaSauceType"),
				SlotTypeVersion: aws.String("$LATEST"),
				ValueElicitationPrompt: &lexmodelbuildingservice.Prompt{
					MaxAttempts: aws.Int64(1),
					Messages: []lexmodelbuildingservice.Message{
						{
							Content:     aws.String("White or red sauce?"),
							ContentType: lexmodelbuildingservice.ContentTypePlainText,
						},
						{
							Content:     aws.String("Garlic or tomato sauce?"),
							ContentType: lexmodelbuildingservice.ContentTypePlainText,
						},
					},
				},
			},
		},
	}

	req := svc.PutIntentRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lexmodelbuildingservice.ErrCodeConflictException:
				fmt.Println(lexmodelbuildingservice.ErrCodeConflictException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeLimitExceededException:
				fmt.Println(lexmodelbuildingservice.ErrCodeLimitExceededException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeInternalFailureException:
				fmt.Println(lexmodelbuildingservice.ErrCodeInternalFailureException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeBadRequestException:
				fmt.Println(lexmodelbuildingservice.ErrCodeBadRequestException, aerr.Error())
			case lexmodelbuildingservice.ErrCodePreconditionFailedException:
				fmt.Println(lexmodelbuildingservice.ErrCodePreconditionFailedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To Create a Slot Type
//
// This example shows how to create a slot type that describes pizza sauces.
func ExampleClient_PutSlotTypeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := lexmodelbuildingservice.New(cfg)
	input := &lexmodelbuildingservice.PutSlotTypeInput{
		Description: aws.String("Available pizza sauces"),
		EnumerationValues: []lexmodelbuildingservice.EnumerationValue{
			{
				Value: aws.String("red"),
			},
			{
				Value: aws.String("white"),
			},
		},
		Name: aws.String("PizzaSauceType"),
	}

	req := svc.PutSlotTypeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lexmodelbuildingservice.ErrCodeConflictException:
				fmt.Println(lexmodelbuildingservice.ErrCodeConflictException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeLimitExceededException:
				fmt.Println(lexmodelbuildingservice.ErrCodeLimitExceededException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeInternalFailureException:
				fmt.Println(lexmodelbuildingservice.ErrCodeInternalFailureException, aerr.Error())
			case lexmodelbuildingservice.ErrCodeBadRequestException:
				fmt.Println(lexmodelbuildingservice.ErrCodeBadRequestException, aerr.Error())
			case lexmodelbuildingservice.ErrCodePreconditionFailedException:
				fmt.Println(lexmodelbuildingservice.ErrCodePreconditionFailedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
