// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelbuildingservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetBuiltinSlotTypesInput struct {
	_ struct{} `type:"structure"`

	// A list of locales that the slot type supports.
	Locale Locale `location:"querystring" locationName:"locale" type:"string" enum:"true"`

	// The maximum number of slot types to return in the response. The default is
	// 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token that fetches the next page of slot types. If the response
	// to this API call is truncated, Amazon Lex returns a pagination token in the
	// response. To fetch the next page of slot types, specify the pagination token
	// in the next request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Substring to match in built-in slot type signatures. A slot type will be
	// returned if any part of its signature matches the substring. For example,
	// "xyz" matches both "xyzabc" and "abcxyz."
	SignatureContains *string `location:"querystring" locationName:"signatureContains" type:"string"`
}

// String returns the string representation
func (s GetBuiltinSlotTypesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBuiltinSlotTypesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBuiltinSlotTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBuiltinSlotTypesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.Locale) > 0 {
		v := s.Locale

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "locale", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SignatureContains != nil {
		v := *s.SignatureContains

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "signatureContains", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetBuiltinSlotTypesOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, the response includes a pagination token that
	// you can use in your next request to fetch the next page of slot types.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of BuiltInSlotTypeMetadata objects, one entry for each slot type
	// returned.
	SlotTypes []BuiltinSlotTypeMetadata `locationName:"slotTypes" type:"list"`
}

// String returns the string representation
func (s GetBuiltinSlotTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBuiltinSlotTypesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SlotTypes != nil {
		v := s.SlotTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "slotTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetBuiltinSlotTypes = "GetBuiltinSlotTypes"

// GetBuiltinSlotTypesRequest returns a request value for making API operation for
// Amazon Lex Model Building Service.
//
// Gets a list of built-in slot types that meet the specified criteria.
//
// For a list of built-in slot types, see Slot Type Reference (https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference)
// in the Alexa Skills Kit.
//
// This operation requires permission for the lex:GetBuiltInSlotTypes action.
//
//    // Example sending a request using GetBuiltinSlotTypesRequest.
//    req := client.GetBuiltinSlotTypesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinSlotTypes
func (c *Client) GetBuiltinSlotTypesRequest(input *GetBuiltinSlotTypesInput) GetBuiltinSlotTypesRequest {
	op := &aws.Operation{
		Name:       opGetBuiltinSlotTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/builtins/slottypes/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBuiltinSlotTypesInput{}
	}

	req := c.newRequest(op, input, &GetBuiltinSlotTypesOutput{})

	return GetBuiltinSlotTypesRequest{Request: req, Input: input, Copy: c.GetBuiltinSlotTypesRequest}
}

// GetBuiltinSlotTypesRequest is the request type for the
// GetBuiltinSlotTypes API operation.
type GetBuiltinSlotTypesRequest struct {
	*aws.Request
	Input *GetBuiltinSlotTypesInput
	Copy  func(*GetBuiltinSlotTypesInput) GetBuiltinSlotTypesRequest
}

// Send marshals and sends the GetBuiltinSlotTypes API request.
func (r GetBuiltinSlotTypesRequest) Send(ctx context.Context) (*GetBuiltinSlotTypesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBuiltinSlotTypesResponse{
		GetBuiltinSlotTypesOutput: r.Request.Data.(*GetBuiltinSlotTypesOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetBuiltinSlotTypesRequestPaginator returns a paginator for GetBuiltinSlotTypes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetBuiltinSlotTypesRequest(input)
//   p := lexmodelbuildingservice.NewGetBuiltinSlotTypesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetBuiltinSlotTypesPaginator(req GetBuiltinSlotTypesRequest) GetBuiltinSlotTypesPaginator {
	return GetBuiltinSlotTypesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetBuiltinSlotTypesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetBuiltinSlotTypesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetBuiltinSlotTypesPaginator struct {
	aws.Pager
}

func (p *GetBuiltinSlotTypesPaginator) CurrentPage() *GetBuiltinSlotTypesOutput {
	return p.Pager.CurrentPage().(*GetBuiltinSlotTypesOutput)
}

// GetBuiltinSlotTypesResponse is the response type for the
// GetBuiltinSlotTypes API operation.
type GetBuiltinSlotTypesResponse struct {
	*GetBuiltinSlotTypesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBuiltinSlotTypes request.
func (r *GetBuiltinSlotTypesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
