// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AttachStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The instance name to which you want to attach the static IP address.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The name of the static IP.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachStaticIpInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttachStaticIpInput"}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if s.StaticIpName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AttachStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AttachStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

const opAttachStaticIp = "AttachStaticIp"

// AttachStaticIpRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Attaches a static IP address to a specific Amazon Lightsail instance.
//
//    // Example sending a request using AttachStaticIpRequest.
//    req := client.AttachStaticIpRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp
func (c *Client) AttachStaticIpRequest(input *AttachStaticIpInput) AttachStaticIpRequest {
	op := &aws.Operation{
		Name:       opAttachStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachStaticIpInput{}
	}

	req := c.newRequest(op, input, &AttachStaticIpOutput{})

	return AttachStaticIpRequest{Request: req, Input: input, Copy: c.AttachStaticIpRequest}
}

// AttachStaticIpRequest is the request type for the
// AttachStaticIp API operation.
type AttachStaticIpRequest struct {
	*aws.Request
	Input *AttachStaticIpInput
	Copy  func(*AttachStaticIpInput) AttachStaticIpRequest
}

// Send marshals and sends the AttachStaticIp API request.
func (r AttachStaticIpRequest) Send(ctx context.Context) (*AttachStaticIpResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AttachStaticIpResponse{
		AttachStaticIpOutput: r.Request.Data.(*AttachStaticIpOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AttachStaticIpResponse is the response type for the
// AttachStaticIp API operation.
type AttachStaticIpResponse struct {
	*AttachStaticIpOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AttachStaticIp request.
func (r *AttachStaticIpResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
