// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateInstanceSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The Lightsail instance on which to base your snapshot.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The name for your new snapshot.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// To tag a resource after it has been created, see the tag resource operation.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateInstanceSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateInstanceSnapshotInput"}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if s.InstanceSnapshotName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateInstanceSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstanceSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateInstanceSnapshot = "CreateInstanceSnapshot"

// CreateInstanceSnapshotRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Creates a snapshot of a specific virtual private server, or instance. You
// can use a snapshot to create a new instance that is based on that snapshot.
//
// The create instance snapshot operation supports tag-based access control
// via request tags. For more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using CreateInstanceSnapshotRequest.
//    req := client.CreateInstanceSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot
func (c *Client) CreateInstanceSnapshotRequest(input *CreateInstanceSnapshotInput) CreateInstanceSnapshotRequest {
	op := &aws.Operation{
		Name:       opCreateInstanceSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceSnapshotInput{}
	}

	req := c.newRequest(op, input, &CreateInstanceSnapshotOutput{})

	return CreateInstanceSnapshotRequest{Request: req, Input: input, Copy: c.CreateInstanceSnapshotRequest}
}

// CreateInstanceSnapshotRequest is the request type for the
// CreateInstanceSnapshot API operation.
type CreateInstanceSnapshotRequest struct {
	*aws.Request
	Input *CreateInstanceSnapshotInput
	Copy  func(*CreateInstanceSnapshotInput) CreateInstanceSnapshotRequest
}

// Send marshals and sends the CreateInstanceSnapshot API request.
func (r CreateInstanceSnapshotRequest) Send(ctx context.Context) (*CreateInstanceSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateInstanceSnapshotResponse{
		CreateInstanceSnapshotOutput: r.Request.Data.(*CreateInstanceSnapshotOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateInstanceSnapshotResponse is the response type for the
// CreateInstanceSnapshot API operation.
type CreateInstanceSnapshotResponse struct {
	*CreateInstanceSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateInstanceSnapshot request.
func (r *CreateInstanceSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
