// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetContactMethodsInput struct {
	_ struct{} `type:"structure"`

	// The protocols used to send notifications, such as Email, or SMS (text messaging).
	//
	// Specify a protocol in your request to return information about a specific
	// contact method protocol.
	Protocols []ContactProtocol `locationName:"protocols" type:"list"`
}

// String returns the string representation
func (s GetContactMethodsInput) String() string {
	return awsutil.Prettify(s)
}

type GetContactMethodsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the contact methods.
	ContactMethods []ContactMethod `locationName:"contactMethods" type:"list"`
}

// String returns the string representation
func (s GetContactMethodsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetContactMethods = "GetContactMethods"

// GetContactMethodsRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about the configured contact methods. Specify a protocol
// in your request to return information about a specific contact method.
//
// A contact method is used to send you notifications about your Amazon Lightsail
// resources. You can add one email address and one mobile phone number contact
// method in each AWS Region. However, SMS text messaging is not supported in
// some AWS Regions, and SMS text messages cannot be sent to some countries/regions.
// For more information, see Notifications in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
//
//    // Example sending a request using GetContactMethodsRequest.
//    req := client.GetContactMethodsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContactMethods
func (c *Client) GetContactMethodsRequest(input *GetContactMethodsInput) GetContactMethodsRequest {
	op := &aws.Operation{
		Name:       opGetContactMethods,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactMethodsInput{}
	}

	req := c.newRequest(op, input, &GetContactMethodsOutput{})

	return GetContactMethodsRequest{Request: req, Input: input, Copy: c.GetContactMethodsRequest}
}

// GetContactMethodsRequest is the request type for the
// GetContactMethods API operation.
type GetContactMethodsRequest struct {
	*aws.Request
	Input *GetContactMethodsInput
	Copy  func(*GetContactMethodsInput) GetContactMethodsRequest
}

// Send marshals and sends the GetContactMethods API request.
func (r GetContactMethodsRequest) Send(ctx context.Context) (*GetContactMethodsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetContactMethodsResponse{
		GetContactMethodsOutput: r.Request.Data.(*GetContactMethodsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetContactMethodsResponse is the response type for the
// GetContactMethods API operation.
type GetContactMethodsResponse struct {
	*GetContactMethodsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetContactMethods request.
func (r *GetContactMethodsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
