// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetDisksInput struct {
	_ struct{} `type:"structure"`

	// The token to advance to the next page of results from your request.
	//
	// To get a page token, perform an initial GetDisks request. If your results
	// are paginated, the response will return a next page token that you can specify
	// as the page token in a subsequent request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetDisksInput) String() string {
	return awsutil.Prettify(s)
}

type GetDisksOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects containing information about all block storage disks.
	Disks []Disk `locationName:"disks" type:"list"`

	// The token to advance to the next page of resutls from your request.
	//
	// A next page token is not returned if there are no more results to display.
	//
	// To get the next page of results, perform another GetDisks request and specify
	// the next page token using the pageToken parameter.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetDisksOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDisks = "GetDisks"

// GetDisksRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about all block storage disks in your AWS account and
// region.
//
//    // Example sending a request using GetDisksRequest.
//    req := client.GetDisksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks
func (c *Client) GetDisksRequest(input *GetDisksInput) GetDisksRequest {
	op := &aws.Operation{
		Name:       opGetDisks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDisksInput{}
	}

	req := c.newRequest(op, input, &GetDisksOutput{})

	return GetDisksRequest{Request: req, Input: input, Copy: c.GetDisksRequest}
}

// GetDisksRequest is the request type for the
// GetDisks API operation.
type GetDisksRequest struct {
	*aws.Request
	Input *GetDisksInput
	Copy  func(*GetDisksInput) GetDisksRequest
}

// Send marshals and sends the GetDisks API request.
func (r GetDisksRequest) Send(ctx context.Context) (*GetDisksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDisksResponse{
		GetDisksOutput: r.Request.Data.(*GetDisksOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDisksResponse is the response type for the
// GetDisks API operation.
type GetDisksResponse struct {
	*GetDisksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDisks request.
func (r *GetDisksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
