// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetInstanceAccessDetailsInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance to access.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The protocol to use to connect to your instance. Defaults to ssh.
	Protocol InstanceAccessProtocol `locationName:"protocol" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetInstanceAccessDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceAccessDetailsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetInstanceAccessDetailsInput"}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetInstanceAccessDetailsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about a get instance access
	// request.
	AccessDetails *InstanceAccessDetails `locationName:"accessDetails" type:"structure"`
}

// String returns the string representation
func (s GetInstanceAccessDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetInstanceAccessDetails = "GetInstanceAccessDetails"

// GetInstanceAccessDetailsRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns temporary SSH keys you can use to connect to a specific virtual private
// server, or instance.
//
// The get instance access details operation supports tag-based access control
// via resource tags applied to the resource identified by instance name. For
// more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using GetInstanceAccessDetailsRequest.
//    req := client.GetInstanceAccessDetailsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails
func (c *Client) GetInstanceAccessDetailsRequest(input *GetInstanceAccessDetailsInput) GetInstanceAccessDetailsRequest {
	op := &aws.Operation{
		Name:       opGetInstanceAccessDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceAccessDetailsInput{}
	}

	req := c.newRequest(op, input, &GetInstanceAccessDetailsOutput{})

	return GetInstanceAccessDetailsRequest{Request: req, Input: input, Copy: c.GetInstanceAccessDetailsRequest}
}

// GetInstanceAccessDetailsRequest is the request type for the
// GetInstanceAccessDetails API operation.
type GetInstanceAccessDetailsRequest struct {
	*aws.Request
	Input *GetInstanceAccessDetailsInput
	Copy  func(*GetInstanceAccessDetailsInput) GetInstanceAccessDetailsRequest
}

// Send marshals and sends the GetInstanceAccessDetails API request.
func (r GetInstanceAccessDetailsRequest) Send(ctx context.Context) (*GetInstanceAccessDetailsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetInstanceAccessDetailsResponse{
		GetInstanceAccessDetailsOutput: r.Request.Data.(*GetInstanceAccessDetailsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetInstanceAccessDetailsResponse is the response type for the
// GetInstanceAccessDetails API operation.
type GetInstanceAccessDetailsResponse struct {
	*GetInstanceAccessDetailsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetInstanceAccessDetails request.
func (r *GetInstanceAccessDetailsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
