// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetInstanceMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The end time of the time period.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The name of the instance for which you want to get metrics data.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The metric for which you want to return information.
	//
	// Valid instance metric names are listed below, along with the most useful
	// statistics to include in your request, and the published unit value.
	//
	//    * BurstCapacityPercentage - The percentage of CPU performance available
	//    for your instance to burst above its baseline. Your instance continuously
	//    accrues and consumes burst capacity. Burst capacity stops accruing when
	//    your instance's BurstCapacityPercentage reaches 100%. For more information,
	//    see Viewing instance burst capacity in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity).
	//    Statistics: The most useful statistics are Maximum and Average. Unit:
	//    The published unit is Percent.
	//
	//    * BurstCapacityTime - The available amount of time for your instance to
	//    burst at 100% CPU utilization. Your instance continuously accrues and
	//    consumes burst capacity. Burst capacity time stops accruing when your
	//    instance's BurstCapacityPercentage metric reaches 100%. Burst capacity
	//    time is consumed at the full rate only when your instance operates at
	//    100% CPU utilization. For example, if your instance operates at 50% CPU
	//    utilization in the burstable zone for a 5-minute period, then it consumes
	//    CPU burst capacity minutes at a 50% rate in that period. Your instance
	//    consumed 2 minutes and 30 seconds of CPU burst capacity minutes in the
	//    5-minute period. For more information, see Viewing instance burst capacity
	//    in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity).
	//    Statistics: The most useful statistics are Maximum and Average. Unit:
	//    The published unit is Seconds.
	//
	//    * CPUUtilization - The percentage of allocated compute units that are
	//    currently in use on the instance. This metric identifies the processing
	//    power to run the applications on the instance. Tools in your operating
	//    system can show a lower percentage than Lightsail when the instance is
	//    not allocated a full processor core. Statistics: The most useful statistics
	//    are Maximum and Average. Unit: The published unit is Percent.
	//
	//    * NetworkIn - The number of bytes received on all network interfaces by
	//    the instance. This metric identifies the volume of incoming network traffic
	//    to the instance. The number reported is the number of bytes received during
	//    the period. Because this metric is reported in 5-minute intervals, divide
	//    the reported number by 300 to find Bytes/second. Statistics: The most
	//    useful statistic is Sum. Unit: The published unit is Bytes.
	//
	//    * NetworkOut - The number of bytes sent out on all network interfaces
	//    by the instance. This metric identifies the volume of outgoing network
	//    traffic from the instance. The number reported is the number of bytes
	//    sent during the period. Because this metric is reported in 5-minute intervals,
	//    divide the reported number by 300 to find Bytes/second. Statistics: The
	//    most useful statistic is Sum. Unit: The published unit is Bytes.
	//
	//    * StatusCheckFailed - Reports whether the instance passed or failed both
	//    the instance status check and the system status check. This metric can
	//    be either 0 (passed) or 1 (failed). This metric data is available in 1-minute
	//    (60 seconds) granularity. Statistics: The most useful statistic is Sum.
	//    Unit: The published unit is Count.
	//
	//    * StatusCheckFailed_Instance - Reports whether the instance passed or
	//    failed the instance status check. This metric can be either 0 (passed)
	//    or 1 (failed). This metric data is available in 1-minute (60 seconds)
	//    granularity. Statistics: The most useful statistic is Sum. Unit: The published
	//    unit is Count.
	//
	//    * StatusCheckFailed_System - Reports whether the instance passed or failed
	//    the system status check. This metric can be either 0 (passed) or 1 (failed).
	//    This metric data is available in 1-minute (60 seconds) granularity. Statistics:
	//    The most useful statistic is Sum. Unit: The published unit is Count.
	//
	// MetricName is a required field
	MetricName InstanceMetricName `locationName:"metricName" type:"string" required:"true" enum:"true"`

	// The granularity, in seconds, of the returned data points.
	//
	// The StatusCheckFailed, StatusCheckFailed_Instance, and StatusCheckFailed_System
	// instance metric data is available in 1-minute (60 seconds) granularity. All
	// other instance metric data is available in 5-minute (300 seconds) granularity.
	//
	// Period is a required field
	Period *int64 `locationName:"period" min:"60" type:"integer" required:"true"`

	// The start time of the time period.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The statistic for the metric.
	//
	// The following statistics are available:
	//
	//    * Minimum - The lowest value observed during the specified period. Use
	//    this value to determine low volumes of activity for your application.
	//
	//    * Maximum - The highest value observed during the specified period. Use
	//    this value to determine high volumes of activity for your application.
	//
	//    * Sum - All values submitted for the matching metric added together. You
	//    can use this statistic to determine the total volume of a metric.
	//
	//    * Average - The value of Sum / SampleCount during the specified period.
	//    By comparing this statistic with the Minimum and Maximum values, you can
	//    determine the full scope of a metric and how close the average use is
	//    to the Minimum and Maximum values. This comparison helps you to know when
	//    to increase or decrease your resources.
	//
	//    * SampleCount - The count, or number, of data points used for the statistical
	//    calculation.
	//
	// Statistics is a required field
	Statistics []MetricStatistic `locationName:"statistics" type:"list" required:"true"`

	// The unit for the metric data request. Valid units depend on the metric data
	// being requested. For the valid units to specify with each available metric,
	// see the metricName parameter.
	//
	// Unit is a required field
	Unit MetricUnit `locationName:"unit" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GetInstanceMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceMetricDataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetInstanceMetricDataInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}
	if len(s.MetricName) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}

	if s.Period == nil {
		invalidParams.Add(aws.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(aws.NewErrParamMinValue("Period", 60))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}

	if s.Statistics == nil {
		invalidParams.Add(aws.NewErrParamRequired("Statistics"))
	}
	if len(s.Unit) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Unit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetInstanceMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the metric data returned.
	MetricData []MetricDatapoint `locationName:"metricData" type:"list"`

	// The name of the metric returned.
	MetricName InstanceMetricName `locationName:"metricName" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetInstanceMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetInstanceMetricData = "GetInstanceMetricData"

// GetInstanceMetricDataRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns the data points for the specified Amazon Lightsail instance metric,
// given an instance name.
//
// Metrics report the utilization of your resources, and the error counts generated
// by them. Monitor and collect metric data regularly to maintain the reliability,
// availability, and performance of your resources.
//
//    // Example sending a request using GetInstanceMetricDataRequest.
//    req := client.GetInstanceMetricDataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData
func (c *Client) GetInstanceMetricDataRequest(input *GetInstanceMetricDataInput) GetInstanceMetricDataRequest {
	op := &aws.Operation{
		Name:       opGetInstanceMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceMetricDataInput{}
	}

	req := c.newRequest(op, input, &GetInstanceMetricDataOutput{})

	return GetInstanceMetricDataRequest{Request: req, Input: input, Copy: c.GetInstanceMetricDataRequest}
}

// GetInstanceMetricDataRequest is the request type for the
// GetInstanceMetricData API operation.
type GetInstanceMetricDataRequest struct {
	*aws.Request
	Input *GetInstanceMetricDataInput
	Copy  func(*GetInstanceMetricDataInput) GetInstanceMetricDataRequest
}

// Send marshals and sends the GetInstanceMetricData API request.
func (r GetInstanceMetricDataRequest) Send(ctx context.Context) (*GetInstanceMetricDataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetInstanceMetricDataResponse{
		GetInstanceMetricDataOutput: r.Request.Data.(*GetInstanceMetricDataOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetInstanceMetricDataResponse is the response type for the
// GetInstanceMetricData API operation.
type GetInstanceMetricDataResponse struct {
	*GetInstanceMetricDataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetInstanceMetricData request.
func (r *GetInstanceMetricDataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
