// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name of the key pair for which you are requesting information.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyPairInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetKeyPairInput"}

	if s.KeyPairName == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyPairName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the key pair.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation
func (s GetKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetKeyPair = "GetKeyPair"

// GetKeyPairRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about a specific key pair.
//
//    // Example sending a request using GetKeyPairRequest.
//    req := client.GetKeyPairRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair
func (c *Client) GetKeyPairRequest(input *GetKeyPairInput) GetKeyPairRequest {
	op := &aws.Operation{
		Name:       opGetKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyPairInput{}
	}

	req := c.newRequest(op, input, &GetKeyPairOutput{})

	return GetKeyPairRequest{Request: req, Input: input, Copy: c.GetKeyPairRequest}
}

// GetKeyPairRequest is the request type for the
// GetKeyPair API operation.
type GetKeyPairRequest struct {
	*aws.Request
	Input *GetKeyPairInput
	Copy  func(*GetKeyPairInput) GetKeyPairRequest
}

// Send marshals and sends the GetKeyPair API request.
func (r GetKeyPairRequest) Send(ctx context.Context) (*GetKeyPairResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetKeyPairResponse{
		GetKeyPairOutput: r.Request.Data.(*GetKeyPairOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetKeyPairResponse is the response type for the
// GetKeyPair API operation.
type GetKeyPairResponse struct {
	*GetKeyPairOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetKeyPair request.
func (r *GetKeyPairResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
