// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetRelationalDatabaseMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The end of the time interval from which to get metric data.
	//
	// Constraints:
	//
	//    * Specified in Coordinated Universal Time (UTC).
	//
	//    * Specified in the Unix time format. For example, if you wish to use an
	//    end time of October 1, 2018, at 8 PM UTC, then you input 1538424000 as
	//    the end time.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The metric for which you want to return information.
	//
	// Valid relational database metric names are listed below, along with the most
	// useful statistics to include in your request, and the published unit value.
	// All relational database metric data is available in 1-minute (60 seconds)
	// granularity.
	//
	//    * CPUUtilization - The percentage of CPU utilization currently in use
	//    on the database. Statistics: The most useful statistics are Maximum and
	//    Average. Unit: The published unit is Percent.
	//
	//    * DatabaseConnections - The number of database connections in use. Statistics:
	//    The most useful statistics are Maximum and Sum. Unit: The published unit
	//    is Count.
	//
	//    * DiskQueueDepth - The number of outstanding IOs (read/write requests)
	//    that are waiting to access the disk. Statistics: The most useful statistic
	//    is Sum. Unit: The published unit is Count.
	//
	//    * FreeStorageSpace - The amount of available storage space. Statistics:
	//    The most useful statistic is Sum. Unit: The published unit is Bytes.
	//
	//    * NetworkReceiveThroughput - The incoming (Receive) network traffic on
	//    the database, including both customer database traffic and AWS traffic
	//    used for monitoring and replication. Statistics: The most useful statistic
	//    is Average. Unit: The published unit is Bytes/Second.
	//
	//    * NetworkTransmitThroughput - The outgoing (Transmit) network traffic
	//    on the database, including both customer database traffic and AWS traffic
	//    used for monitoring and replication. Statistics: The most useful statistic
	//    is Average. Unit: The published unit is Bytes/Second.
	//
	// MetricName is a required field
	MetricName RelationalDatabaseMetricName `locationName:"metricName" type:"string" required:"true" enum:"true"`

	// The granularity, in seconds, of the returned data points.
	//
	// All relational database metric data is available in 1-minute (60 seconds)
	// granularity.
	//
	// Period is a required field
	Period *int64 `locationName:"period" min:"60" type:"integer" required:"true"`

	// The name of your database from which to get metric data.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// The start of the time interval from which to get metric data.
	//
	// Constraints:
	//
	//    * Specified in Coordinated Universal Time (UTC).
	//
	//    * Specified in the Unix time format. For example, if you wish to use a
	//    start time of October 1, 2018, at 8 PM UTC, then you input 1538424000
	//    as the start time.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The statistic for the metric.
	//
	// The following statistics are available:
	//
	//    * Minimum - The lowest value observed during the specified period. Use
	//    this value to determine low volumes of activity for your application.
	//
	//    * Maximum - The highest value observed during the specified period. Use
	//    this value to determine high volumes of activity for your application.
	//
	//    * Sum - All values submitted for the matching metric added together. You
	//    can use this statistic to determine the total volume of a metric.
	//
	//    * Average - The value of Sum / SampleCount during the specified period.
	//    By comparing this statistic with the Minimum and Maximum values, you can
	//    determine the full scope of a metric and how close the average use is
	//    to the Minimum and Maximum values. This comparison helps you to know when
	//    to increase or decrease your resources.
	//
	//    * SampleCount - The count, or number, of data points used for the statistical
	//    calculation.
	//
	// Statistics is a required field
	Statistics []MetricStatistic `locationName:"statistics" type:"list" required:"true"`

	// The unit for the metric data request. Valid units depend on the metric data
	// being requested. For the valid units with each available metric, see the
	// metricName parameter.
	//
	// Unit is a required field
	Unit MetricUnit `locationName:"unit" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseMetricDataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRelationalDatabaseMetricDataInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}
	if len(s.MetricName) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}

	if s.Period == nil {
		invalidParams.Add(aws.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(aws.NewErrParamMinValue("Period", 60))
	}

	if s.RelationalDatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RelationalDatabaseName"))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}

	if s.Statistics == nil {
		invalidParams.Add(aws.NewErrParamRequired("Statistics"))
	}
	if len(s.Unit) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Unit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetRelationalDatabaseMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the metric data returned.
	MetricData []MetricDatapoint `locationName:"metricData" type:"list"`

	// The name of the metric returned.
	MetricName RelationalDatabaseMetricName `locationName:"metricName" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetRelationalDatabaseMetricData = "GetRelationalDatabaseMetricData"

// GetRelationalDatabaseMetricDataRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns the data points of the specified metric for a database in Amazon
// Lightsail.
//
// Metrics report the utilization of your resources, and the error counts generated
// by them. Monitor and collect metric data regularly to maintain the reliability,
// availability, and performance of your resources.
//
//    // Example sending a request using GetRelationalDatabaseMetricDataRequest.
//    req := client.GetRelationalDatabaseMetricDataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMetricData
func (c *Client) GetRelationalDatabaseMetricDataRequest(input *GetRelationalDatabaseMetricDataInput) GetRelationalDatabaseMetricDataRequest {
	op := &aws.Operation{
		Name:       opGetRelationalDatabaseMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseMetricDataInput{}
	}

	req := c.newRequest(op, input, &GetRelationalDatabaseMetricDataOutput{})

	return GetRelationalDatabaseMetricDataRequest{Request: req, Input: input, Copy: c.GetRelationalDatabaseMetricDataRequest}
}

// GetRelationalDatabaseMetricDataRequest is the request type for the
// GetRelationalDatabaseMetricData API operation.
type GetRelationalDatabaseMetricDataRequest struct {
	*aws.Request
	Input *GetRelationalDatabaseMetricDataInput
	Copy  func(*GetRelationalDatabaseMetricDataInput) GetRelationalDatabaseMetricDataRequest
}

// Send marshals and sends the GetRelationalDatabaseMetricData API request.
func (r GetRelationalDatabaseMetricDataRequest) Send(ctx context.Context) (*GetRelationalDatabaseMetricDataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRelationalDatabaseMetricDataResponse{
		GetRelationalDatabaseMetricDataOutput: r.Request.Data.(*GetRelationalDatabaseMetricDataOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRelationalDatabaseMetricDataResponse is the response type for the
// GetRelationalDatabaseMetricData API operation.
type GetRelationalDatabaseMetricDataResponse struct {
	*GetRelationalDatabaseMetricDataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRelationalDatabaseMetricData request.
func (r *GetRelationalDatabaseMetricDataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
