// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetRelationalDatabaseParametersInput struct {
	_ struct{} `type:"structure"`

	// The token to advance to the next page of results from your request.
	//
	// To get a page token, perform an initial GetRelationalDatabaseParameters request.
	// If your results are paginated, the response will return a next page token
	// that you can specify as the page token in a subsequent request.
	PageToken *string `locationName:"pageToken" type:"string"`

	// The name of your database for which to get parameters.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseParametersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseParametersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRelationalDatabaseParametersInput"}

	if s.RelationalDatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetRelationalDatabaseParametersOutput struct {
	_ struct{} `type:"structure"`

	// The token to advance to the next page of resutls from your request.
	//
	// A next page token is not returned if there are no more results to display.
	//
	// To get the next page of results, perform another GetRelationalDatabaseParameters
	// request and specify the next page token using the pageToken parameter.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An object describing the result of your get relational database parameters
	// request.
	Parameters []RelationalDatabaseParameter `locationName:"parameters" type:"list"`
}

// String returns the string representation
func (s GetRelationalDatabaseParametersOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetRelationalDatabaseParameters = "GetRelationalDatabaseParameters"

// GetRelationalDatabaseParametersRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns all of the runtime parameters offered by the underlying database
// software, or engine, for a specific database in Amazon Lightsail.
//
// In addition to the parameter names and values, this operation returns other
// information about each parameter. This information includes whether changes
// require a reboot, whether the parameter is modifiable, the allowed values,
// and the data types.
//
//    // Example sending a request using GetRelationalDatabaseParametersRequest.
//    req := client.GetRelationalDatabaseParametersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseParameters
func (c *Client) GetRelationalDatabaseParametersRequest(input *GetRelationalDatabaseParametersInput) GetRelationalDatabaseParametersRequest {
	op := &aws.Operation{
		Name:       opGetRelationalDatabaseParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseParametersInput{}
	}

	req := c.newRequest(op, input, &GetRelationalDatabaseParametersOutput{})

	return GetRelationalDatabaseParametersRequest{Request: req, Input: input, Copy: c.GetRelationalDatabaseParametersRequest}
}

// GetRelationalDatabaseParametersRequest is the request type for the
// GetRelationalDatabaseParameters API operation.
type GetRelationalDatabaseParametersRequest struct {
	*aws.Request
	Input *GetRelationalDatabaseParametersInput
	Copy  func(*GetRelationalDatabaseParametersInput) GetRelationalDatabaseParametersRequest
}

// Send marshals and sends the GetRelationalDatabaseParameters API request.
func (r GetRelationalDatabaseParametersRequest) Send(ctx context.Context) (*GetRelationalDatabaseParametersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRelationalDatabaseParametersResponse{
		GetRelationalDatabaseParametersOutput: r.Request.Data.(*GetRelationalDatabaseParametersOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRelationalDatabaseParametersResponse is the response type for the
// GetRelationalDatabaseParameters API operation.
type GetRelationalDatabaseParametersResponse struct {
	*GetRelationalDatabaseParametersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRelationalDatabaseParameters request.
func (r *GetRelationalDatabaseParametersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
