// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetRelationalDatabaseSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the database snapshot for which to get information.
	//
	// RelationalDatabaseSnapshotName is a required field
	RelationalDatabaseSnapshotName *string `locationName:"relationalDatabaseSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRelationalDatabaseSnapshotInput"}

	if s.RelationalDatabaseSnapshotName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RelationalDatabaseSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetRelationalDatabaseSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the specified database snapshot.
	RelationalDatabaseSnapshot *RelationalDatabaseSnapshot `locationName:"relationalDatabaseSnapshot" type:"structure"`
}

// String returns the string representation
func (s GetRelationalDatabaseSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetRelationalDatabaseSnapshot = "GetRelationalDatabaseSnapshot"

// GetRelationalDatabaseSnapshotRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about a specific database snapshot in Amazon Lightsail.
//
//    // Example sending a request using GetRelationalDatabaseSnapshotRequest.
//    req := client.GetRelationalDatabaseSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshot
func (c *Client) GetRelationalDatabaseSnapshotRequest(input *GetRelationalDatabaseSnapshotInput) GetRelationalDatabaseSnapshotRequest {
	op := &aws.Operation{
		Name:       opGetRelationalDatabaseSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseSnapshotInput{}
	}

	req := c.newRequest(op, input, &GetRelationalDatabaseSnapshotOutput{})

	return GetRelationalDatabaseSnapshotRequest{Request: req, Input: input, Copy: c.GetRelationalDatabaseSnapshotRequest}
}

// GetRelationalDatabaseSnapshotRequest is the request type for the
// GetRelationalDatabaseSnapshot API operation.
type GetRelationalDatabaseSnapshotRequest struct {
	*aws.Request
	Input *GetRelationalDatabaseSnapshotInput
	Copy  func(*GetRelationalDatabaseSnapshotInput) GetRelationalDatabaseSnapshotRequest
}

// Send marshals and sends the GetRelationalDatabaseSnapshot API request.
func (r GetRelationalDatabaseSnapshotRequest) Send(ctx context.Context) (*GetRelationalDatabaseSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRelationalDatabaseSnapshotResponse{
		GetRelationalDatabaseSnapshotOutput: r.Request.Data.(*GetRelationalDatabaseSnapshotOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRelationalDatabaseSnapshotResponse is the response type for the
// GetRelationalDatabaseSnapshot API operation.
type GetRelationalDatabaseSnapshotResponse struct {
	*GetRelationalDatabaseSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRelationalDatabaseSnapshot request.
func (r *GetRelationalDatabaseSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
