// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SendContactMethodVerificationInput struct {
	_ struct{} `type:"structure"`

	// The protocol to verify, such as Email or SMS (text messaging).
	//
	// Protocol is a required field
	Protocol ContactMethodVerificationProtocol `locationName:"protocol" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SendContactMethodVerificationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendContactMethodVerificationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SendContactMethodVerificationInput"}
	if len(s.Protocol) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Protocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SendContactMethodVerificationOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s SendContactMethodVerificationOutput) String() string {
	return awsutil.Prettify(s)
}

const opSendContactMethodVerification = "SendContactMethodVerification"

// SendContactMethodVerificationRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Sends a verification request to an email contact method to ensure it's owned
// by the requester. SMS contact methods don't need to be verified.
//
// A contact method is used to send you notifications about your Amazon Lightsail
// resources. You can add one email address and one mobile phone number contact
// method in each AWS Region. However, SMS text messaging is not supported in
// some AWS Regions, and SMS text messages cannot be sent to some countries/regions.
// For more information, see Notifications in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
//
// A verification request is sent to the contact method when you initially create
// it. Use this action to send another verification request if a previous verification
// request was deleted, or has expired.
//
// Notifications are not sent to an email contact method until after it is verified,
// and confirmed as valid.
//
//    // Example sending a request using SendContactMethodVerificationRequest.
//    req := client.SendContactMethodVerificationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SendContactMethodVerification
func (c *Client) SendContactMethodVerificationRequest(input *SendContactMethodVerificationInput) SendContactMethodVerificationRequest {
	op := &aws.Operation{
		Name:       opSendContactMethodVerification,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendContactMethodVerificationInput{}
	}

	req := c.newRequest(op, input, &SendContactMethodVerificationOutput{})

	return SendContactMethodVerificationRequest{Request: req, Input: input, Copy: c.SendContactMethodVerificationRequest}
}

// SendContactMethodVerificationRequest is the request type for the
// SendContactMethodVerification API operation.
type SendContactMethodVerificationRequest struct {
	*aws.Request
	Input *SendContactMethodVerificationInput
	Copy  func(*SendContactMethodVerificationInput) SendContactMethodVerificationRequest
}

// Send marshals and sends the SendContactMethodVerification API request.
func (r SendContactMethodVerificationRequest) Send(ctx context.Context) (*SendContactMethodVerificationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SendContactMethodVerificationResponse{
		SendContactMethodVerificationOutput: r.Request.Data.(*SendContactMethodVerificationOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SendContactMethodVerificationResponse is the response type for the
// SendContactMethodVerification API operation.
type SendContactMethodVerificationResponse struct {
	*SendContactMethodVerificationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SendContactMethodVerification request.
func (r *SendContactMethodVerificationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
