// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance (a virtual private server) to start.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s StartInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartInstanceInput"}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s StartInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartInstance = "StartInstance"

// StartInstanceRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Starts a specific Amazon Lightsail instance from a stopped state. To restart
// an instance, use the reboot instance operation.
//
// When you start a stopped instance, Lightsail assigns a new public IP address
// to the instance. To use the same IP address after stopping and starting an
// instance, create a static IP address and attach it to the instance. For more
// information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip).
//
// The start instance operation supports tag-based access control via resource
// tags applied to the resource identified by instance name. For more information,
// see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using StartInstanceRequest.
//    req := client.StartInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance
func (c *Client) StartInstanceRequest(input *StartInstanceInput) StartInstanceRequest {
	op := &aws.Operation{
		Name:       opStartInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInstanceInput{}
	}

	req := c.newRequest(op, input, &StartInstanceOutput{})

	return StartInstanceRequest{Request: req, Input: input, Copy: c.StartInstanceRequest}
}

// StartInstanceRequest is the request type for the
// StartInstance API operation.
type StartInstanceRequest struct {
	*aws.Request
	Input *StartInstanceInput
	Copy  func(*StartInstanceInput) StartInstanceRequest
}

// Send marshals and sends the StartInstance API request.
func (r StartInstanceRequest) Send(ctx context.Context) (*StartInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartInstanceResponse{
		StartInstanceOutput: r.Request.Data.(*StartInstanceOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartInstanceResponse is the response type for the
// StartInstance API operation.
type StartInstanceResponse struct {
	*StartInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartInstance request.
func (r *StartInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
