// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopInstanceInput struct {
	_ struct{} `type:"structure"`

	// When set to True, forces a Lightsail instance that is stuck in a stopping
	// state to stop.
	//
	// Only use the force parameter if your instance is stuck in the stopping state.
	// In any other state, your instance should stop normally without adding this
	// parameter to your API request.
	Force *bool `locationName:"force" type:"boolean"`

	// The name of the instance (a virtual private server) to stop.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s StopInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopInstanceInput"}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s StopInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopInstance = "StopInstance"

// StopInstanceRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Stops a specific Amazon Lightsail instance that is currently running.
//
// When you start a stopped instance, Lightsail assigns a new public IP address
// to the instance. To use the same IP address after stopping and starting an
// instance, create a static IP address and attach it to the instance. For more
// information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip).
//
// The stop instance operation supports tag-based access control via resource
// tags applied to the resource identified by instance name. For more information,
// see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using StopInstanceRequest.
//    req := client.StopInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance
func (c *Client) StopInstanceRequest(input *StopInstanceInput) StopInstanceRequest {
	op := &aws.Operation{
		Name:       opStopInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopInstanceInput{}
	}

	req := c.newRequest(op, input, &StopInstanceOutput{})

	return StopInstanceRequest{Request: req, Input: input, Copy: c.StopInstanceRequest}
}

// StopInstanceRequest is the request type for the
// StopInstance API operation.
type StopInstanceRequest struct {
	*aws.Request
	Input *StopInstanceInput
	Copy  func(*StopInstanceInput) StopInstanceRequest
}

// Send marshals and sends the StopInstance API request.
func (r StopInstanceRequest) Send(ctx context.Context) (*StopInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopInstanceResponse{
		StopInstanceOutput: r.Request.Data.(*StopInstanceOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopInstanceResponse is the response type for the
// StopInstance API operation.
type StopInstanceResponse struct {
	*StopInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopInstance request.
func (r *StopInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
